/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.escloud.httpClient;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class Client {
    public String request(String method, String uri, Map<String, String> params, Map<String, String> headers) throws UnsupportedEncodingException, URISyntaxException, JSONException {
        Object request = null;
        if (method.equals("GET")) {
            HttpGet get = new HttpGet();
            if (!params.isEmpty()) {
                StringBuilder uriBuilder = new StringBuilder(uri.indexOf("?") > 0 ? uri + "&" : uri + "?");
                for (String key : params.keySet()) {
                    uriBuilder.append(params.get(key)).append("=");
                }
                uri = uriBuilder.toString();
                uri = uri.substring(0, uri.length() - 1);
            }
            get.setURI(new URI(uri));
            request = get;
        } else if (method.equals("POST")) {
            HttpPost post = new HttpPost();
            post.setURI(new URI(uri));
            post.setEntity((HttpEntity)new StringEntity(this.prepareParams(params), "UTF-8"));
            request = post;
        } else if (method.equals("PUT")) {
            HttpPut put = new HttpPut();
            put.setURI(new URI(uri));
            put.setEntity((HttpEntity)new StringEntity(this.prepareParams(params), "UTF-8"));
            request = put;
        } else if (method.equals("PATCH")) {
            HttpPatch patch = new HttpPatch();
            patch.setURI(new URI(uri));
            patch.setEntity((HttpEntity)new StringEntity(this.prepareParams(params), "UTF-8"));
            request = patch;
        } else if (method.equals("DELETE")) {
            HttpDelete delete = new HttpDelete();
            delete.setURI(new URI(uri));
            request = delete;
        }
        if (request != null && headers != null) {
            for (String key : headers.keySet()) {
                request.setHeader(key, headers.get(key));
            }
        }
        CloseableHttpResponse httpResponse = null;
        try {
            CloseableHttpClient httpclient = null;
            httpclient = HttpClients.createDefault();
            httpResponse = httpclient.execute((HttpUriRequest)request);
            HttpEntity responseEntity = httpResponse.getEntity();
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new Exception(EntityUtils.toString((HttpEntity)responseEntity));
            }
            return EntityUtils.toString((HttpEntity)responseEntity);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public String request(String method, String uri, byte[] body, Map<String, String> headers) throws URISyntaxException, JSONException {
        HttpPost request = null;
        HttpPost post = new HttpPost();
        post.setURI(new URI(uri));
        post.setEntity((HttpEntity)new ByteArrayEntity(body));
        request = post;
        if (request != null && headers != null) {
            for (String key : headers.keySet()) {
                request.setHeader(key, headers.get(key));
            }
        }
        try {
            CloseableHttpResponse httpResponse = null;
            CloseableHttpClient httpclient = null;
            httpclient = HttpClients.createDefault();
            httpResponse = httpclient.execute((HttpUriRequest)request);
            HttpEntity responseEntity = httpResponse.getEntity();
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new Exception(EntityUtils.toString((HttpEntity)responseEntity));
            }
            return EntityUtils.toString((HttpEntity)responseEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private String prepareParams(Map<String, String> params) throws JSONException {
        JSONObject json = new JSONObject();
        for (String key : params.keySet()) {
            json.put(key, (Object)params.get(key));
        }
        return json.toString();
    }

    private static class HttpMethodType {
        private static final String GET = "GET";
        private static final String PUT = "PUT";
        private static final String POST = "POST";
        private static final String DELETE = "DELETE";
        private static final String PATCH = "PATCH";

        private HttpMethodType() {
        }
    }
}

