/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.escloud.service;

import com.codeages.escloud.Auth;
import com.codeages.escloud.httpClient.Client;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Map;
import org.json.JSONException;

public class BaseService {
    protected Auth auth;
    private Client client;
    protected String host;
    protected String leafHost;

    public void init(Auth auth, Map<String, String> options) {
        this.auth = auth;
        if (options.containsKey("host")) {
            this.host = options.get("host");
        }
        if (options.containsKey("leafHost")) {
            this.leafHost = options.get("leafHost");
        }
    }

    protected Client createClient() {
        if (this.client != null) {
            return this.client;
        }
        this.client = new Client();
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    protected String request(String method, String uri, Map<String, String> params, Map<String, String> headers, String node) throws URISyntaxException, UnsupportedEncodingException, JSONException {
        String authorization = this.auth.makeRequestAuthorization(uri, 600);
        headers.put("Authorization", authorization);
        headers.put("Content-Type", "application/json");
        return this.createClient().request(method, this.getRequestUri(uri, node), params, headers);
    }

    private String getRequestUri(String uri, String node) {
        this.host = this.getHostByNode(node);
        if (this.host.isEmpty()) {
            throw new RuntimeException("API host is not exist or invalid.");
        }
        return "http://" + this.host + uri;
    }

    private String getHostByNode(String node) {
        if (node.equals("leaf")) {
            return this.leafHost.isEmpty() ? this.host : this.leafHost;
        }
        return this.host;
    }
}

