/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.escloud.service;

import com.codeages.escloud.Auth;
import com.codeages.escloud.domain.Resource;
import com.codeages.escloud.helper.upload.FileRecorder;
import com.codeages.escloud.helper.upload.UploadManager;
import com.codeages.escloud.service.BaseService;
import com.codeages.escloud.util.Json;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;

public class ResourceService
extends BaseService {
    protected String host = "resource-service.qiqiuyun.net";
    protected String recordPath = "logs/tmp/";

    public ResourceService(Auth auth, Map<String, String> options) {
        options.put("host", this.host);
        this.init(auth, options);
    }

    public Resource get(String no) throws UnsupportedEncodingException, URISyntaxException, JSONException {
        return Json.jsonToObject(this.request("GET", "/resources/" + no, new HashMap<String, String>(), new HashMap<String, String>(), "root"), Resource.class);
    }

    public List<Resource> search(Map<String, String> params) throws UnsupportedEncodingException, URISyntaxException, JSONException {
        return Json.jsonToObjectList(this.request("GET", "/resources", params, new HashMap<String, String>(), "root"), Resource.class);
    }

    public Map getDownloadUrl(String no) throws UnsupportedEncodingException, URISyntaxException, JSONException {
        return Json.jsonToObject(this.request("GET", "/resources/" + no + "/downloadUrl", new HashMap<String, String>(), new HashMap<String, String>(), "root"), Map.class);
    }

    public Resource rename(String no, String name) throws UnsupportedEncodingException, URISyntaxException, JSONException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", name);
        return Json.jsonToObject(this.request("PUT", "/resources/" + no + "/name", params, new HashMap<String, String>(), "root"), Resource.class);
    }

    public String delete(String no) throws UnsupportedEncodingException, URISyntaxException, JSONException {
        return this.request("DELETE", "/resources/" + no, new HashMap<String, String>(), new HashMap<String, String>(), "root");
    }

    public Map startUpload(Map<String, String> params) throws UnsupportedEncodingException, URISyntaxException, JSONException {
        return Json.jsonToObject(this.request("POST", "/upload/start", params, new HashMap<String, String>(), "root"), Map.class);
    }

    public Map finishUpload(String no) throws UnsupportedEncodingException, URISyntaxException, JSONException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("no", no);
        return Json.jsonToObject(this.request("POST", "/upload/finish", params, new HashMap<String, String>(), "root"), Map.class);
    }

    public Map upload(File file, String extno) throws IOException, URISyntaxException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", file.getName());
        params.put("extno", extno);
        Map token = this.startUpload(params);
        FileRecorder recorder = new FileRecorder(this.recordPath);
        UploadManager uploadManager = new UploadManager(recorder);
        uploadManager.upload(file, token.get("reskey").toString(), token.get("uploadToken").toString());
        return this.finishUpload(token.get("no").toString());
    }

    public Map upload(File file, String extno, String resumeNo) throws IOException, URISyntaxException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", file.getName());
        params.put("extno", extno);
        params.put("resumeNo", resumeNo);
        Map token = this.startUpload(params);
        FileRecorder recorder = new FileRecorder(this.recordPath);
        UploadManager uploadManager = new UploadManager(recorder);
        uploadManager.upload(file, token.get("reskey").toString(), token.get("uploadToken").toString());
        return this.finishUpload(token.get("no").toString());
    }
}

