/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Screenshots;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.SelenidePageFactory;
import com.codeborne.selenide.SelenideTargetLocator;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.ex.DialogTextMismatch;
import com.codeborne.selenide.ex.JavaScriptErrorsFound;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.ElementFinder;
import com.codeborne.selenide.impl.Navigator;
import com.codeborne.selenide.impl.SelenideFieldDecorator;
import com.codeborne.selenide.impl.WebElementWrapper;
import com.codeborne.selenide.impl.WebElementsCollectionWrapper;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import org.openqa.selenium.support.ui.FluentWait;

public class Selenide {
    private static final Logger log = Logger.getLogger(Selenide.class.getName());
    public static Navigator navigator = new Navigator();

    public static void open(String relativeOrAbsoluteUrl) {
        Selenide.open(relativeOrAbsoluteUrl, "", "", "");
    }

    public static void open(URL absoluteUrl) {
        Selenide.open(absoluteUrl, "", "", "");
    }

    public static void open(String relativeOrAbsoluteUrl, String domain, String login, String password) {
        navigator.open(relativeOrAbsoluteUrl, domain, login, password);
        Selenide.mockModalDialogs();
    }

    public static void open(URL absoluteUrl, String domain, String login, String password) {
        navigator.open(absoluteUrl, domain, login, password);
        Selenide.mockModalDialogs();
    }

    public static void updateHash(String hash) {
        String localHash = hash.charAt(0) == '#' ? hash.substring(1) : hash;
        Selenide.executeJavaScript("window.location.hash='" + localHash + "'", new Object[0]);
    }

    private static boolean doDismissModalDialogs() {
        return !WebDriverRunner.supportsModalDialogs() || Configuration.dismissModalDialogs;
    }

    private static void mockModalDialogs() {
        if (Selenide.doDismissModalDialogs()) {
            String jsCode = "  window._selenide_modalDialogReturnValue = true;\n  window.alert = function(message) {};\n  window.confirm = function(message) {\n    return window._selenide_modalDialogReturnValue;\n  };";
            try {
                Selenide.executeJavaScript(jsCode, new Object[0]);
            }
            catch (UnsupportedOperationException cannotExecuteJsAgainstPlainTextPage) {
                log.warning(cannotExecuteJsAgainstPlainTextPage.toString());
            }
        }
    }

    public static <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        return Selenide.open(relativeOrAbsoluteUrl, "", "", "", pageObjectClassClass);
    }

    public static <PageObjectClass> PageObjectClass open(URL absoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        return Selenide.open(absoluteUrl, "", "", "", pageObjectClassClass);
    }

    public static <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        Selenide.open(relativeOrAbsoluteUrl, domain, login, password);
        return Selenide.page(pageObjectClassClass);
    }

    public static <PageObjectClass> PageObjectClass open(URL absoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        Selenide.open(absoluteUrl, domain, login, password);
        return Selenide.page(pageObjectClassClass);
    }

    public static void close() {
        WebDriverRunner.closeWebDriver();
    }

    public static void refresh() {
        navigator.open(WebDriverRunner.url());
    }

    public static void back() {
        navigator.back();
    }

    public static void forward() {
        navigator.forward();
    }

    public static String title() {
        return WebDriverRunner.getWebDriver().getTitle();
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static String screenshot(String fileName) {
        return Screenshots.takeScreenShot(fileName);
    }

    public static SelenideElement $(WebElement webElement) {
        return WebElementWrapper.wrap(webElement);
    }

    public static SelenideElement $(String cssSelector) {
        return Selenide.getElement(By.cssSelector((String)cssSelector));
    }

    public static SelenideElement $x(String xpathExpression) {
        return Selenide.getElement(By.xpath((String)xpathExpression));
    }

    public static SelenideElement $(By seleniumSelector) {
        return Selenide.getElement(seleniumSelector);
    }

    public static SelenideElement $(By seleniumSelector, int index) {
        return Selenide.getElement(seleniumSelector, index);
    }

    @Deprecated
    public static SelenideElement $(WebElement parent, String cssSelector) {
        return ElementFinder.wrap((SearchContext)Selenide.$(parent), By.cssSelector((String)cssSelector), 0);
    }

    public static SelenideElement $(String cssSelector, int index) {
        return ElementFinder.wrap(null, By.cssSelector((String)cssSelector), index);
    }

    @Deprecated
    public static SelenideElement $(WebElement parent, String cssSelector, int index) {
        return ElementFinder.wrap((SearchContext)Selenide.$(parent), By.cssSelector((String)cssSelector), index);
    }

    @Deprecated
    public static SelenideElement $(WebElement parent, By seleniumSelector) {
        return ElementFinder.wrap((SearchContext)Selenide.$(parent), seleniumSelector, 0);
    }

    @Deprecated
    public static SelenideElement $(WebElement parent, By seleniumSelector, int index) {
        return ElementFinder.wrap((SearchContext)Selenide.$(parent), seleniumSelector, index);
    }

    public static ElementsCollection $$(Collection<? extends WebElement> elements) {
        return new ElementsCollection(new WebElementsCollectionWrapper(elements));
    }

    public static ElementsCollection $$(String cssSelector) {
        return new ElementsCollection(new BySelectorCollection(By.cssSelector((String)cssSelector)));
    }

    public static ElementsCollection $$x(String xpathExpression) {
        return new ElementsCollection(new BySelectorCollection(By.xpath((String)xpathExpression)));
    }

    public static ElementsCollection $$(By seleniumSelector) {
        return new ElementsCollection(new BySelectorCollection(seleniumSelector));
    }

    @Deprecated
    public static ElementsCollection $$(WebElement parent, String cssSelector) {
        return new ElementsCollection(new BySelectorCollection((SearchContext)parent, By.cssSelector((String)cssSelector)));
    }

    @Deprecated
    public static ElementsCollection $$(WebElement parent, By seleniumSelector) {
        return new ElementsCollection(new BySelectorCollection((SearchContext)parent, seleniumSelector));
    }

    public static SelenideElement getElement(By criteria) {
        return ElementFinder.wrap(null, criteria, 0);
    }

    public static SelenideElement getElement(By criteria, int index) {
        return ElementFinder.wrap(null, criteria, index);
    }

    public static ElementsCollection getElements(By criteria) {
        return Selenide.$$(criteria);
    }

    public static <T> T executeJavaScript(String jsCode, Object ... arguments) {
        return (T)((JavascriptExecutor)WebDriverRunner.getWebDriver()).executeScript(jsCode, arguments);
    }

    @Deprecated
    public static SelenideElement selectRadio(By radioField, String value) {
        return Selenide.$(radioField).selectRadio(value);
    }

    public static SelenideElement getSelectedRadio(By radioField) {
        for (WebElement radio : Selenide.$$(radioField)) {
            if (radio.getAttribute("checked") == null) continue;
            return WebElementWrapper.wrap(radio);
        }
        return null;
    }

    public static void onConfirmReturn(boolean confirmReturnValue) {
        if (Selenide.doDismissModalDialogs()) {
            Selenide.executeJavaScript("window._selenide_modalDialogReturnValue = " + confirmReturnValue + ';', new Object[0]);
        }
    }

    public static String confirm() {
        return Selenide.confirm(null);
    }

    public static String confirm(String expectedDialogText) {
        if (!Selenide.doDismissModalDialogs()) {
            Alert alert = Selenide.switchTo().alert();
            String actualDialogText = alert.getText();
            alert.accept();
            Selenide.checkDialogText(expectedDialogText, actualDialogText);
            return actualDialogText;
        }
        return null;
    }

    public static String prompt() {
        return Selenide.prompt(null, null);
    }

    public static String prompt(String inputText) {
        return Selenide.prompt(null, inputText);
    }

    public static String prompt(String expectedDialogText, String inputText) {
        if (!Selenide.doDismissModalDialogs()) {
            Alert alert = Selenide.switchTo().alert();
            String actualDialogText = alert.getText();
            if (inputText != null) {
                alert.sendKeys(inputText);
            }
            alert.accept();
            Selenide.checkDialogText(expectedDialogText, actualDialogText);
            return actualDialogText;
        }
        return null;
    }

    public static String dismiss() {
        return Selenide.dismiss(null);
    }

    public static String dismiss(String expectedDialogText) {
        if (!Selenide.doDismissModalDialogs()) {
            Alert alert = Selenide.switchTo().alert();
            String actualDialogText = alert.getText();
            alert.dismiss();
            Selenide.checkDialogText(expectedDialogText, actualDialogText);
            return actualDialogText;
        }
        return null;
    }

    private static void checkDialogText(String expectedDialogText, String actualDialogText) {
        if (expectedDialogText != null && !expectedDialogText.equals(actualDialogText)) {
            Screenshots.takeScreenShot(Selenide.class.getName(), Thread.currentThread().getName());
            throw new DialogTextMismatch(actualDialogText, expectedDialogText);
        }
    }

    public static SelenideTargetLocator switchTo() {
        return new SelenideTargetLocator(WebDriverRunner.getWebDriver().switchTo());
    }

    public static WebElement getFocusedElement() {
        return (WebElement)Selenide.executeJavaScript("return document.activeElement", new Object[0]);
    }

    public static <PageObjectClass> PageObjectClass page(Class<PageObjectClass> pageObjectClass) {
        try {
            Constructor<PageObjectClass> constructor = pageObjectClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return Selenide.page(constructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create new instance of " + pageObjectClass, e);
        }
    }

    public static <PageObjectClass, T extends PageObjectClass> PageObjectClass page(T pageObject) {
        SelenidePageFactory.initElements((FieldDecorator)new SelenideFieldDecorator((SearchContext)WebDriverRunner.getWebDriver()), pageObject);
        return pageObject;
    }

    public static FluentWait<WebDriver> Wait() {
        return new FluentWait((Object)WebDriverRunner.getWebDriver()).withTimeout(Configuration.timeout, TimeUnit.MILLISECONDS).pollingEvery(Configuration.pollingInterval, TimeUnit.MILLISECONDS);
    }

    public static Actions actions() {
        return new Actions(WebDriverRunner.getWebDriver());
    }

    public static List<String> getJavascriptErrors() {
        if (!Configuration.captureJavascriptErrors) {
            return Collections.emptyList();
        }
        if (!WebDriverRunner.hasWebDriverStarted()) {
            return Collections.emptyList();
        }
        if (!WebDriverRunner.supportsJavascript()) {
            return Collections.emptyList();
        }
        try {
            Object errors = Selenide.executeJavaScript("return window._selenide_jsErrors", new Object[0]);
            if (errors == null) {
                return Collections.emptyList();
            }
            if (errors instanceof List) {
                return Selenide.errorsFromList((List)errors);
            }
            if (errors instanceof Map) {
                return Selenide.errorsFromMap((Map)errors);
            }
            return Arrays.asList(errors.toString());
        }
        catch (UnsupportedOperationException | WebDriverException cannotExecuteJs) {
            log.warning(cannotExecuteJs.toString());
            return Collections.emptyList();
        }
    }

    private static List<String> errorsFromList(List<Object> errors) {
        if (errors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(errors.size());
        for (Object error : errors) {
            result.add(error.toString());
        }
        return result;
    }

    private static List<String> errorsFromMap(Map<Object, Object> errors) {
        if (errors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(errors.size());
        for (Map.Entry<Object, Object> error : errors.entrySet()) {
            result.add(error.getKey() + ": " + error.getValue());
        }
        return result;
    }

    public static void assertNoJavascriptErrors() throws JavaScriptErrorsFound {
        List<String> jsErrors = Selenide.getJavascriptErrors();
        if (jsErrors != null && !jsErrors.isEmpty()) {
            throw new JavaScriptErrorsFound(jsErrors);
        }
    }

    public static void zoom(double factor) {
        Selenide.executeJavaScript("document.body.style.transform = 'scale(' + arguments[0] + ')';document.body.style.transformOrigin = '0 0';", factor);
    }

    public static List<String> getWebDriverLogs(String logType) {
        return Selenide.getWebDriverLogs(logType, Level.ALL);
    }

    public static List<String> getWebDriverLogs(String logType, Level logLevel) {
        return Selenide.listToString(Selenide.getLogEntries(logType, logLevel));
    }

    public static void clearBrowserCookies() {
        WebDriverRunner.getWebDriver().manage().deleteAllCookies();
    }

    public static void clearBrowserLocalStorage() {
        Selenide.executeJavaScript("localStorage.clear();", new Object[0]);
    }

    private static List<LogEntry> getLogEntries(String logType, Level logLevel) {
        try {
            return WebDriverRunner.getWebDriver().manage().logs().get(logType).filter(logLevel);
        }
        catch (UnsupportedOperationException ignore) {
            return Collections.emptyList();
        }
    }

    private static <T> List<String> listToString(List<T> objects) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(objects.size());
        for (T object : objects) {
            result.add(object.toString());
        }
        return result;
    }
}

