/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.WebElementWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class SelenideElementListProxy
implements InvocationHandler {
    private final ElementLocator locator;

    public static List<SelenideElement> wrap(ElementLocator locator) {
        SelenideElementListProxy handler = new SelenideElementListProxy(locator);
        return (List)Proxy.newProxyInstance(SelenideElementListProxy.class.getClassLoader(), new Class[]{List.class}, (InvocationHandler)handler);
    }

    private SelenideElementListProxy(ElementLocator locator) {
        this.locator = locator;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ArrayList<SelenideElement> elements = new ArrayList<SelenideElement>();
        for (WebElement webElement : this.locator.findElements()) {
            elements.add(WebElementWrapper.wrap(webElement));
        }
        try {
            return method.invoke(elements, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

