/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;

class ChromeDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(ChromeDriverFactory.class.getName());

    ChromeDriverFactory() {
    }

    @Override
    WebDriver create(Proxy proxy) {
        ChromeOptions options = this.createChromeOptions(proxy);
        return new ChromeDriver(options);
    }

    @Override
    boolean supports() {
        return "chrome".equalsIgnoreCase(Configuration.browser);
    }

    ChromeOptions createChromeOptions(Proxy proxy) {
        ChromeOptions options = new ChromeOptions();
        options.setHeadless(Configuration.headless);
        options.addArguments(new String[]{"--no-sandbox"});
        if (Configuration.chromeSwitches != null) {
            options.addArguments(new String[]{Configuration.chromeSwitches});
        }
        options.merge((Capabilities)this.createCommonCapabilities(proxy));
        options = this.transferChromeOptionsFromSystemProperties(options);
        log.config("Chrome options:" + options.toString());
        return options;
    }

    private ChromeOptions transferChromeOptionsFromSystemProperties(ChromeOptions currentChromeOptions) {
        String prefix = "chromeoptions.";
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String capability = key.substring(prefix.length());
            String value = System.getProperties().getProperty(key);
            if (capability.equals("args")) {
                List<String> args = Arrays.asList(value.split(","));
                currentChromeOptions.addArguments(args);
                continue;
            }
            log.warning(capability + "is ignored.Only so-called arguments (chromeoptions.args=<values comma separated>) are supported for the chromeoptions at the moment");
        }
        return currentChromeOptions;
    }
}

