/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

class HtmlUnitDriverFactory
extends AbstractDriverFactory {
    HtmlUnitDriverFactory() {
    }

    @Override
    boolean supports() {
        return WebDriverRunner.isHtmlUnit();
    }

    @Override
    WebDriver create(Proxy proxy) {
        return this.createHtmlUnitDriver(proxy);
    }

    private WebDriver createHtmlUnitDriver(Proxy proxy) {
        DesiredCapabilities capabilities = DesiredCapabilities.htmlUnit();
        capabilities.merge((Capabilities)this.createCommonCapabilities(proxy));
        capabilities.setCapability("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", true);
        capabilities.setCapability("The xpath expression '%s' cannot be evaluated", false);
        if (Configuration.browser.indexOf(58) > -1) {
            String emulatedBrowser = Configuration.browser.replaceFirst("htmlunit:(.*)", "$1");
            capabilities.setVersion(emulatedBrowser);
        }
        return new HtmlUnitDriver((Capabilities)capabilities);
    }
}

