/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;

class RemoteDriverFactory
extends AbstractDriverFactory {
    RemoteDriverFactory() {
    }

    @Override
    boolean supports() {
        return Configuration.remote != null;
    }

    @Override
    WebDriver create(Proxy proxy) {
        return this.createRemoteDriver(Configuration.remote, Configuration.browser, proxy);
    }

    private WebDriver createRemoteDriver(String remote, String browser, Proxy proxy) {
        try {
            DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
            capabilities.setBrowserName(WebDriverRunner.isIE() ? "internet explorer" : browser);
            RemoteWebDriver webDriver = new RemoteWebDriver(new URL(remote), (Capabilities)capabilities);
            webDriver.setFileDetector((FileDetector)new LocalFileDetector());
            return webDriver;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid 'remote' parameter: " + remote, e);
        }
    }
}

