/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.request;

import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusProtocolException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusFileRecord;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadFileRecordResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ReadFileRecordRequest
extends ModbusRequest {
    public static final int READ__SUB_REQ_LENGTH = 7;
    final List<ModbusFileRecord> records = new ArrayList<ModbusFileRecord>();

    public void addFileRecord(ModbusFileRecord record) {
        this.records.add(record);
    }

    public void addFileRecords(Collection<ModbusFileRecord> records) {
        this.records.addAll(records);
    }

    @Override
    protected Class getResponseClass() {
        return ReadFileRecordResponse.class;
    }

    @Override
    public void writeRequest(ModbusOutputStream fifo) throws IOException {
        fifo.write(7 * this.records.size());
        for (ModbusFileRecord record : this.records) {
            fifo.write(6);
            fifo.writeShortBE(record.getFileNumber());
            fifo.writeShortBE(record.getRecordNumber());
            fifo.writeShortBE(record.getRecordLength());
        }
    }

    @Override
    public void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
        int byteCount = fifo.read();
        if (byteCount > 252) {
            throw new ModbusNumberException("Byte count greater than max allowable");
        }
        for (int read = 0; read < byteCount; read += 7) {
            if (fifo.read() != 6) {
                throw new ModbusNumberException("Reference type mismatch.");
            }
            int file_number = fifo.readShortBE();
            int record_number = fifo.readShortBE();
            int record_length = fifo.readShortBE();
            this.records.add(new ModbusFileRecord(file_number, record_number, record_length));
        }
    }

    @Override
    public int requestSize() {
        return 1 + 7 * this.records.size();
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        ReadFileRecordResponse response = (ReadFileRecordResponse)this.getResponse();
        try {
            for (ModbusFileRecord r : this.records) {
                dataHolder.readFileRecord(r);
            }
            response.setFileRecords((ModbusFileRecord[])this.records.toArray());
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    protected boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof ReadFileRecordResponse)) {
            return false;
        }
        ModbusFileRecord[] respRecords = ((ReadFileRecordResponse)response).getFileRecords();
        if (this.records.size() != respRecords.length) {
            return false;
        }
        for (int i = 0; i < this.records.size(); ++i) {
            if (respRecords[i].getRecordLength() == this.records.get(i).getRecordLength()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_FILE_RECORD.toInt();
    }
}

