/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.request;

import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusProtocolException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadHoldingRegistersRequest;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadInputRegistersResponse;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;

public final class ReadInputRegistersRequest
extends ReadHoldingRegistersRequest {
    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        ReadInputRegistersResponse response = (ReadInputRegistersResponse)this.getResponse();
        response.setServerAddress(this.getServerAddress());
        try {
            int[] range = dataHolder.readInputRegisterRange(this.getStartAddress(), this.getQuantity());
            response.setBuffer(range);
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof ReadInputRegistersResponse)) {
            return false;
        }
        ReadInputRegistersResponse r = (ReadInputRegistersResponse)response;
        return r.getByteCount() == this.getQuantity() * 2;
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_INPUT_REGISTERS.toInt();
    }

    @Override
    protected Class getResponseClass() {
        return ReadInputRegistersResponse.class;
    }
}

