/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.response;

import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusFileRecord;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.DataUtils;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class WriteFileRecordResponse
extends ModbusResponse {
    public static final int READ_SUB_REQ_LENGTH = 7;
    private ModbusFileRecord record = null;

    @Override
    protected void readResponse(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        int byteCount = fifo.read();
        if (byteCount > 252) {
            throw new ModbusNumberException("Byte count greater than max allowable");
        }
        if (fifo.read() != 6) {
            throw new ModbusNumberException("Reference type mismatch.");
        }
        int file_number = fifo.readShortBE();
        int record_number = fifo.readShortBE();
        int record_length = fifo.readShortBE();
        byte[] buffer = new byte[record_length * 2];
        if (fifo.read(buffer) != buffer.length) {
            throw new ModbusNumberException(record_length + " bytes expected, but not received.");
        }
        this.record = new ModbusFileRecord(file_number, record_number, DataUtils.BeToIntArray(buffer));
    }

    @Override
    protected void writeResponse(ModbusOutputStream fifo) throws IOException {
        fifo.write(7 + this.record.getRecordLength() * 2);
        fifo.write(6);
        fifo.writeShortBE(this.record.getFileNumber());
        fifo.writeShortBE(this.record.getRecordNumber());
        fifo.writeShortBE(this.record.getRecordLength());
        fifo.write(DataUtils.toByteArray(this.record.getRegisters()));
    }

    public ModbusFileRecord getFileRecord() {
        return this.record;
    }

    public void setFileRecord(ModbusFileRecord record) {
        this.record = record;
    }

    @Override
    protected int responseSize() {
        return 1 + 7 * this.record.getRecordLength() * 2;
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.WRITE_FILE_RECORD.toInt();
    }
}

