/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.eslivesdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.UrlQuerySanitizer;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Base64;
import android.view.View;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebIconDatabase;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewDatabase;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import com.tencent.smtt.sdk.QbSdk;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

public class LiveCloudUtils {
    public static final int SDKVersion = 5;
    private static final String ALLOWED_CHARACTERS = "0123456789qwertyuiopasdfghjklzxcvbnm";
    private static final String LCPref = "LiveCloudPref";

    protected static String randomString(int sizeOfRandomString) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder(sizeOfRandomString);
        for (int i = 0; i < sizeOfRandomString; ++i) {
            sb.append(ALLOWED_CHARACTERS.charAt(random.nextInt(ALLOWED_CHARACTERS.length())));
        }
        return sb.toString();
    }

    public static Map<String, Object> parseJwt(String url) {
        String token = new UrlQuerySanitizer(url).getValue("token");
        if (token == null) {
            return new HashMap<String, Object>();
        }
        String[] chunks = token.split("\\.");
        if (chunks.length < 1) {
            return new HashMap<String, Object>();
        }
        String header = new String(Base64.decode((String)chunks[0], (int)8));
        String payload = new String(Base64.decode((String)chunks[1], (int)8));
        try {
            JSONObject hJson = new JSONObject(header);
            JSONObject pJson = new JSONObject(payload);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("kid", hJson.get("kid"));
            result.put("rid", pJson.get("rid"));
            result.put("role", pJson.get("role"));
            result.put("uid", pJson.get("uid"));
            result.put("name", pJson.get("name"));
            return result;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new HashMap<String, Object>();
        }
    }

    protected static Map<String, Object> deviceInfo(Context context) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("device", Build.MANUFACTURER + Build.MODEL);
        result.put("osName", "android");
        result.put("osVersion", Build.VERSION.RELEASE);
        result.put("network", LiveCloudUtils.getNetworkState(context));
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            result.put("appName", pi.applicationInfo.loadLabel(pm).toString());
        }
        catch (PackageManager.NameNotFoundException e) {
            result.put("appName", context.getApplicationInfo().processName);
        }
        result.put("appVersion", LiveCloudUtils.getAppVersion(context));
        result.put("sdkVersion", 5);
        result.put("resolution", context.getResources().getDisplayMetrics().widthPixels + "x" + context.getResources().getDisplayMetrics().heightPixels);
        return result;
    }

    protected static void checkClearCaches(Context context) {
        try {
            String nowVersion = LiveCloudUtils.getAppVersion(context);
            SharedPreferences sharedPref = context.getSharedPreferences(LCPref, 0);
            String lastVersion = sharedPref.getString("appVersion", null);
            if (lastVersion == null || !lastVersion.equals(nowVersion)) {
                LiveCloudUtils.deleteCache(context);
            }
            SharedPreferences.Editor editor = sharedPref.edit();
            editor.putString("appVersion", nowVersion);
            editor.apply();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void deleteCache(Context context) {
        Context appContext = context.getApplicationContext();
        QbSdk.clearAllWebViewCache((Context)appContext, (boolean)true);
        WebView webView = new WebView(appContext);
        webView.removeJavascriptInterface("searchBoxJavaBridge_");
        webView.removeJavascriptInterface("accessibility");
        webView.removeJavascriptInterface("accessibilityTraversal");
        webView.clearCache(true);
        CookieSyncManager.createInstance((Context)appContext);
        CookieManager.getInstance().removeAllCookies(null);
        WebViewDatabase.getInstance((Context)appContext).clearUsernamePassword();
        WebViewDatabase.getInstance((Context)appContext).clearHttpAuthUsernamePassword();
        WebViewDatabase.getInstance((Context)appContext).clearFormData();
        WebStorage.getInstance().deleteAllData();
        WebIconDatabase.getInstance().removeAllIcons();
        LiveCloudUtils.deleteDir(new File(appContext.getCacheDir(), "WebView"));
        LiveCloudUtils.deleteDir(new File(appContext.getCacheDir(), "org.chromium.android_webview"));
        if (Build.VERSION.SDK_INT >= 24) {
            LiveCloudUtils.deleteDir(new File(appContext.getDataDir(), "app_webview"));
        }
    }

    private static void deleteDir(File dir) {
        String[] children;
        if (dir == null) {
            return;
        }
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (String child : children) {
                LiveCloudUtils.deleteDir(new File(dir, child));
            }
        }
        dir.delete();
    }

    protected static int connectTimeout(Context context, String roomId) {
        SharedPreferences sharedPref = context.getSharedPreferences(LCPref, 0);
        int times = sharedPref.getInt(roomId, 0) + 1;
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putInt(roomId, times);
        editor.apply();
        return times;
    }

    protected static int getTimeoutTimes(Context context, String roomId) {
        SharedPreferences sharedPref = context.getSharedPreferences(LCPref, 0);
        if (System.currentTimeMillis() - sharedPref.getLong(roomId + "disableX5", 0L) > 30000L) {
            LiveCloudUtils.clearTimeoutTimes(context, roomId);
            LiveCloudUtils.clearDisableX5(context, roomId);
        }
        return sharedPref.getInt(roomId, 0);
    }

    protected static void clearTimeoutTimes(Context context, String roomId) {
        SharedPreferences sharedPref = context.getSharedPreferences(LCPref, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.remove(roomId);
        editor.apply();
    }

    protected static void disableX5(Context context, String roomId) {
        SharedPreferences sharedPref = context.getSharedPreferences(LCPref, 0);
        if (sharedPref.getLong(roomId + "disableX5", 0L) == 0L) {
            SharedPreferences.Editor editor = sharedPref.edit();
            editor.putLong(roomId + "disableX5", System.currentTimeMillis());
            editor.apply();
        }
    }

    protected static void clearDisableX5(Context context, String roomId) {
        SharedPreferences sharedPref = context.getSharedPreferences(LCPref, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.remove(roomId + "disableX5");
        editor.apply();
    }

    protected static void setX5Downloaded(Context context, boolean downloaded) {
        SharedPreferences sharedPref = context.getSharedPreferences(LCPref, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString("x5Downloaded", String.valueOf(downloaded));
        editor.apply();
    }

    protected static String getX5Downloaded(Context context) {
        SharedPreferences sharedPref = context.getSharedPreferences(LCPref, 0);
        return sharedPref.getString("x5Downloaded", null);
    }

    private static String getNetworkState(Context context) {
        NetworkInfo.State state;
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (null == connManager) {
            return "none";
        }
        NetworkInfo activeNetInfo = connManager.getActiveNetworkInfo();
        if (activeNetInfo == null || !activeNetInfo.isAvailable()) {
            return "none";
        }
        NetworkInfo wifiInfo = connManager.getNetworkInfo(1);
        if (null != wifiInfo && null != (state = wifiInfo.getState()) && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
            return "wifi";
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return "cellular";
        }
        int networkType = telephonyManager.getNetworkType();
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return "2G";
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return "3G";
            }
            case 13: {
                return "4G";
            }
        }
        return "cellular";
    }

    private static String getAppVersion(Context context) {
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    protected static void fullScreen(AppCompatActivity activity, boolean isFull) {
        if (isFull) {
            if (Build.VERSION.SDK_INT >= 28) {
                WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
                lp.layoutInDisplayCutoutMode = 1;
                activity.getWindow().setAttributes(lp);
            }
            LiveCloudUtils.hideNavigationBar(activity);
            activity.getWindow().addFlags(1024);
        } else {
            LiveCloudUtils.showNavigationBar(activity);
            activity.getWindow().clearFlags(1024);
        }
    }

    protected static void hideNavigationBar(AppCompatActivity activity) {
        View decorView = activity.getWindow().getDecorView();
        int uiOptions = 7942;
        decorView.setSystemUiVisibility(uiOptions);
    }

    private static void showNavigationBar(AppCompatActivity activity) {
        View decorView = activity.getWindow().getDecorView();
        int uiOptions = 0;
        decorView.setSystemUiVisibility(uiOptions);
    }
}

