/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.eslivesdk.cache;

import android.util.Log;
import com.codeages.eslivesdk.cache.WorkThread;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;

public class CacheServer
extends Thread {
    private boolean isLoop;
    private boolean isPause;
    private ServerSocket mServerSocket;
    private HttpRequestHandlerRegistry mHttpRequestHandlerRegistry;
    private ArrayList<Thread> mThreadList = new ArrayList();

    private CacheServer(Builder builder) {
        this.mHttpRequestHandlerRegistry = new HttpRequestHandlerRegistry();
        this.mHttpRequestHandlerRegistry.register(builder.filter, builder.handler);
    }

    @Override
    public synchronized void start() {
        if (this.isLoop) {
            return;
        }
        super.start();
    }

    @Override
    public void run() {
        if (this.isLoop) {
            return;
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.mServerSocket = null;
        try {
            this.mServerSocket = new ServerSocket();
            this.mServerSocket.setReuseAddress(true);
            this.mServerSocket.bind(new InetSocketAddress(20100));
            BasicHttpProcessor httpproc = new BasicHttpProcessor();
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
            HttpService httpService = new HttpService((HttpProcessor)httpproc, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpResponseFactory)new DefaultHttpResponseFactory());
            BasicHttpParams params = new BasicHttpParams();
            params.setIntParameter("http.socket.timeout", 15000).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)"Android Server/1.1");
            httpService.setParams((HttpParams)params);
            httpService.setHandlerResolver((HttpRequestHandlerResolver)this.mHttpRequestHandlerRegistry);
            this.isLoop = true;
            while (this.isLoop && !Thread.interrupted()) {
                if (this.isPause) continue;
                Socket socket = this.mServerSocket.accept();
                DefaultHttpServerConnection conn = new DefaultHttpServerConnection();
                conn.bind(socket, (HttpParams)params);
                WorkThread t = new WorkThread(httpService, (HttpServerConnection)conn);
                t.setDaemon(true);
                t.start();
                this.mThreadList.add(t);
            }
        }
        catch (IOException e) {
            this.isLoop = false;
        }
        finally {
            try {
                if (this.mServerSocket != null) {
                    this.mServerSocket.close();
                    Log.d(null, (String)"mServerSocket close");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void pause() {
        this.isPause = true;
    }

    void keepOn() {
        this.isPause = false;
    }

    void close() {
        this.isLoop = false;
        try {
            for (Thread t : this.mThreadList) {
                t.interrupt();
            }
            this.mThreadList.clear();
            this.mServerSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Builder {
        private String filter;
        private HttpRequestHandler handler;

        Builder setFilter(String filter) {
            this.filter = filter;
            return this;
        }

        Builder setHandler(HttpRequestHandler handler) {
            this.handler = handler;
            return this;
        }

        public CacheServer build() {
            return new CacheServer(this);
        }
    }
}

