/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.eslivesdk.cache;

import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.PathUtils;
import java.io.File;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.FileEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public class FileHandler
implements HttpRequestHandler {
    private int mRoomId;

    public FileHandler(int roomId) {
        this.mRoomId = roomId;
    }

    public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        try {
            String url = httpRequest.getRequestLine().getUri();
            LogUtils.d((Object[])new Object[]{url});
            String[] split1 = url.split("[.]");
            String suffix = split1.length > 1 ? split1[split1.length - 1] : "";
            String filePath = "";
            if (url.contains("/live_cloud_player")) {
                filePath = PathUtils.getExternalAppFilesPath() + url;
            } else if (url.contains("/live_cloud_replay")) {
                filePath = PathUtils.getExternalAppFilesPath() + url;
            }
            String contentType = "";
            File file = new File(filePath);
            switch (suffix) {
                case "txt": {
                    contentType = "text/plain";
                    break;
                }
                case "html": {
                    contentType = "text/html";
                    break;
                }
                case "js": {
                    contentType = "application/x-javascript";
                    break;
                }
                case "ico": {
                    contentType = "image/x-icon";
                    break;
                }
                case "m3u8": {
                    contentType = "application/vnd.apple.mpegurl";
                    break;
                }
                case "ts": {
                    contentType = "video/mp2t";
                    break;
                }
                case "png": {
                    contentType = "image/png";
                    break;
                }
            }
            FileEntity fileEntity = new FileEntity(file, contentType);
            httpResponse.setEntity((HttpEntity)fileEntity);
        }
        catch (Exception ex) {
            LogUtils.d((Object[])new Object[]{ex.getMessage()});
        }
    }
}

