/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.livecloudsdk;

import com.blankj.utilcode.util.LogUtils;
import com.codeages.livecloudsdk.LiveCloudLogger;
import com.codeages.livecloudsdk.ReplayListener;
import com.codeages.livecloudsdk.bean.ReplayMetas;
import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.OkDownload;
import com.liulishuo.okdownload.SpeedCalculator;
import com.liulishuo.okdownload.core.breakpoint.BlockInfo;
import com.liulishuo.okdownload.core.breakpoint.BreakpointInfo;
import com.liulishuo.okdownload.core.cause.EndCause;
import com.liulishuo.okdownload.core.listener.DownloadListener4WithSpeed;
import com.liulishuo.okdownload.core.listener.assist.Listener4SpeedAssistExtend;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DownloadReplayListener
extends DownloadListener4WithSpeed {
    private final ReplayListener mReplayListener;
    private final ReplayMetas mReplayMetas;
    private final int mIndex;
    private int mDownloadCount = 0;
    private String mUser;

    public DownloadReplayListener(ReplayMetas replayMetas, int index, String user, ReplayListener replayListener) {
        this.mReplayMetas = replayMetas;
        this.mIndex = index;
        this.mUser = user;
        this.mReplayListener = replayListener;
    }

    public void taskStart(@NotNull DownloadTask task) {
    }

    public void connectStart(@NotNull DownloadTask task, int blockIndex, @NotNull Map<String, List<String>> requestHeaderFields) {
    }

    public void connectEnd(@NotNull DownloadTask task, int blockIndex, int responseCode, @NotNull Map<String, List<String>> responseHeaderFields) {
    }

    public void infoReady(@NotNull DownloadTask task, @NotNull BreakpointInfo info, boolean fromBreakpoint, @NotNull Listener4SpeedAssistExtend.Listener4SpeedModel model) {
        LogUtils.i((Object[])new Object[]{String.format("range: %s - %s", info.getBlock(0).getRangeLeft() + "", info.getBlock(0).getRangeRight() + "")});
    }

    public void progressBlock(@NotNull DownloadTask task, int blockIndex, long currentBlockOffset, @NotNull SpeedCalculator blockSpeed) {
        LogUtils.i((Object[])new Object[]{task.getUrl() + "|blockIndex:" + blockIndex});
    }

    public void progress(@NotNull DownloadTask task, long currentOffset, @NotNull SpeedCalculator taskSpeed) {
        this.mReplayListener.onProgress(this.mReplayMetas, this.mIndex, taskSpeed.averageSpeed());
        LogUtils.i((Object[])new Object[]{task.getUrl() + "|taskSpeed:" + taskSpeed.averageSpeed()});
    }

    public void blockEnd(@NotNull DownloadTask task, int blockIndex, BlockInfo info, @NotNull SpeedCalculator blockSpeed) {
        LogUtils.i((Object[])new Object[]{String.format("range: %s - %s", info.getRangeLeft(), info.getRangeRight())});
    }

    public void taskEnd(@NotNull DownloadTask task, @NotNull EndCause cause, Exception realCause, @NotNull SpeedCalculator taskSpeed) {
        if (cause == EndCause.ERROR) {
            ++this.mDownloadCount;
            OkDownload.with().breakpointStore().remove(task.getId());
            if (this.mDownloadCount == 10) {
                new LiveCloudLogger(Long.parseLong(this.mReplayMetas.getRoomId() + ""), Long.parseLong(this.mUser), null).error("OfflineReplay.FetchFileError", task.getUrl(), null);
            }
        }
        LogUtils.i((Object[])new Object[]{task.getUrl() + "EndCause:" + cause.name()});
    }
}

