/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.livecloudsdk;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class HttpThreadPoolUtils {
    private static final int CORE_POOL_SIZE;
    private static final int MAX_POOL_SIZE;
    private static final int KEEP_ALIVE_TIME = 5;
    private static final BlockingQueue<Runnable> workQueue;
    private static final ThreadPoolExecutor mThreadpool;

    private HttpThreadPoolUtils() {
    }

    public static void execute(Runnable runnable) {
        mThreadpool.execute(runnable);
    }

    public static void cancelAll() {
        try {
            mThreadpool.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        MAX_POOL_SIZE = CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2 + 1;
        workQueue = new ArrayBlockingQueue<Runnable>(MAX_POOL_SIZE);
        mThreadpool = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 5L, TimeUnit.SECONDS, workQueue);
    }
}

