/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.livecloudsdk;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.webkit.JavascriptInterface;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.widget.ContentLoadingProgressBar;
import com.codeages.livecloudsdk.LiveCloudHttpClient;
import com.codeages.livecloudsdk.LiveCloudLogger;
import com.codeages.livecloudsdk.LiveCloudUtils;
import com.codeages.livecloudsdk.R;
import com.tencent.smtt.export.external.interfaces.ConsoleMessage;
import com.tencent.smtt.export.external.interfaces.JsPromptResult;
import com.tencent.smtt.export.external.interfaces.JsResult;
import com.tencent.smtt.export.external.interfaces.PermissionRequest;
import com.tencent.smtt.export.external.interfaces.SslError;
import com.tencent.smtt.export.external.interfaces.SslErrorHandler;
import com.tencent.smtt.export.external.interfaces.WebResourceError;
import com.tencent.smtt.export.external.interfaces.WebResourceRequest;
import com.tencent.smtt.sdk.QbSdk;
import com.tencent.smtt.sdk.TbsListener;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebSettings;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LiveCloudActivity
extends AppCompatActivity {
    protected WebView webView;
    protected String url = "";
    protected String logUrl = "";
    protected boolean isLive;
    private boolean disableX5;
    private String roomId = "0";
    private PermissionRequest myRequest;
    private Boolean connect = false;
    private Boolean isFullscreen = false;
    private Long enterTimestamp;
    private ContentLoadingProgressBar loadingView;
    private LiveCloudLogger logger;
    private static final String JSInterface = "LiveCloudBridge";
    private final ActivityResultLauncher<String> requestPermissionLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), isGranted -> this.runOnUiThread(() -> {
        if (isGranted.booleanValue()) {
            this.myRequest.grant(this.myRequest.getResources());
        } else {
            this.myRequest.deny();
        }
    }));

    public static void launch(Context context, String url, boolean isLive, boolean isGrantedPermission, Map<String, Object> options) {
        Intent intent = new Intent(context, LiveCloudActivity.class);
        intent.putExtra("url", url);
        intent.putExtra("isLive", isLive);
        intent.putExtra("isGrantedPermission", isGrantedPermission);
        String roomId = String.valueOf(LiveCloudUtils.parseJwt(url).get("rid"));
        intent.putExtra("roomId", roomId);
        if (options != null && options.get("logUrl") != null) {
            intent.putExtra("logUrl", (String)options.get("logUrl"));
        }
        ProgressDialog progressDialog = ProgressDialog.show((Context)context, (CharSequence)"", (CharSequence)"\u52a0\u8f7d\u4e2d", (boolean)true, (boolean)true);
        LiveCloudUtils.checkClearCaches(context);
        LiveCloudActivity.initTbs(context);
        if (!isLive && QbSdk.getTbsVersion((Context)context) < 45613) {
            QbSdk.forceSysWebView();
            intent.putExtra("disableX5", true);
            context.startActivity(intent);
            progressDialog.dismiss();
            return;
        }
        String blacklistUrl = "https://livecloud-storage-sh.edusoho.net/metas/x5blacklist.json?ts=" + System.currentTimeMillis();
        LiveCloudHttpClient.get(blacklistUrl, 3000, (successMsg, errorMsg) -> {
            if (successMsg != null) {
                String version = String.valueOf(QbSdk.getTbsVersion((Context)context));
                try {
                    JSONObject msg = new JSONObject(successMsg);
                    JSONArray list = msg.getJSONArray(isLive ? "live" : "replay");
                    for (int i = 0; i < list.length(); ++i) {
                        if (!list.getString(i).equals(version)) continue;
                        QbSdk.forceSysWebView();
                        intent.putExtra("disableX5", true);
                        context.startActivity(intent);
                        progressDialog.dismiss();
                        return;
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (LiveCloudUtils.getTimeoutTimes(context, roomId) > 3) {
                QbSdk.forceSysWebView();
                intent.putExtra("disableX5", true);
                LiveCloudUtils.disableX5(context, roomId);
            } else {
                QbSdk.unForceSysWebView();
                intent.putExtra("disableX5", false);
            }
            context.startActivity(intent);
            progressDialog.dismiss();
        });
    }

    public void onBackPressed() {
        if (this.connect.booleanValue()) {
            this.webView.evaluateJavascript("liveCloudNativeEventCallback({name:'back'})", null);
        } else {
            if (this.enterDurationSecond() >= 10L) {
                int times = LiveCloudUtils.connectTimeout((Context)this, this.roomId);
                LiveCloudUtils.deleteCache((Context)this);
                this.logger.warn("SDK.ConnectTimeout", this.roomId + "=" + times, null);
            } else {
                this.logger.warn("SDK.NotConnect", null, null);
            }
            super.onBackPressed();
        }
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(R.style.LiveCloudTheme);
        this.setContentView(R.layout.activity_live_cloud);
        this.getWindow().setFormat(-3);
        this.getWindow().addFlags(128);
        this.url = this.getIntent().getStringExtra("url");
        this.isLive = this.getIntent().getBooleanExtra("isLive", false);
        this.logUrl = this.getIntent().getStringExtra("logUrl");
        this.disableX5 = this.getIntent().getBooleanExtra("disableX5", false);
        this.roomId = this.getIntent().getStringExtra("roomId");
        this.loadingView = (ContentLoadingProgressBar)this.findViewById(R.id.loadingView);
        this.loadingView.show();
        this.logger = new LiveCloudLogger(this.logUrl, this.url);
        this.createWebView();
        this.loadRoomURL();
        this.logger.info("SDK.Enter", new JSONObject(this.deviceInfoMap()).toString(), this.deviceInfoMap());
        if (!this.getIntent().getBooleanExtra("isGrantedPermission", true)) {
            this.logger.debug("SDK.PermissionDeny", null, null);
        }
        this.enterTimestamp = System.currentTimeMillis();
    }

    protected void onResume() {
        super.onResume();
        if (this.webView != null) {
            this.webView.onResume();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.webView != null) {
            this.webView.onPause();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.webView != null) {
            this.webView.removeJavascriptInterface(JSInterface);
            this.webView.setWebViewClient(null);
            this.webView.setWebChromeClient(null);
            this.webView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
            this.webView.clearHistory();
            this.webView.destroy();
            this.webView = null;
        }
    }

    private void loadRoomURL() {
        byte[] infoByte = new JSONObject(this.deviceInfoMap()).toString().getBytes(StandardCharsets.UTF_8);
        String base64String = Build.VERSION.SDK_INT >= 26 ? Base64.getUrlEncoder().withoutPadding().encodeToString(infoByte) : android.util.Base64.encodeToString((byte[])infoByte, (int)11);
        this.webView.loadUrl(this.url + "&device=" + base64String);
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "JavascriptInterface"})
    private void createWebView() {
        QbSdk.setTbsListener((TbsListener)new TbsListener(){

            public void onDownloadFinish(int i) {
            }

            public void onInstallFinish(int i) {
                LiveCloudActivity.this.logger.info("SDK.X5Installed", null, null);
            }

            public void onDownloadProgress(int i) {
            }
        });
        this.webView = (WebView)this.findViewById(R.id.webView);
        this.webView.setWebViewClient(this.createWebViewClient());
        this.webView.setWebChromeClient(this.createWebChromeClient());
        this.webView.addJavascriptInterface((Object)this, JSInterface);
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setCacheMode(-1);
        webSettings.setDefaultTextEncodingName("utf-8");
        webSettings.setDomStorageEnabled(true);
        webSettings.setMixedContentMode(0);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setMediaPlaybackRequiresUserGesture(false);
    }

    private static void initTbs(Context context) {
        QbSdk.setDownloadWithoutWifi((boolean)true);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("use_speedy_classloader", true);
        map.put("use_dexloader_service", true);
        QbSdk.initTbsSettings(map);
        QbSdk.initX5Environment((Context)context.getApplicationContext(), null);
    }

    private Map<String, Object> deviceInfoMap() {
        HashMap<String, Object> info = new HashMap<String, Object>(LiveCloudUtils.deviceInfo((Context)this));
        info.put("x5Version", QbSdk.getTbsVersion((Context)this));
        info.put("disableX5", this.disableX5);
        info.put("x5Loaded", this.webView.getX5WebViewExtension() != null);
        return info;
    }

    private WebViewClient createWebViewClient() {
        return new WebViewClient(){

            public void onPageFinished(WebView webView, String s) {
                super.onPageFinished(webView, s);
                LiveCloudActivity.this.loadingView.hide();
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                LiveCloudActivity.this.logger.debug("SDK.WebViewError", "WebResourceError: " + error.getErrorCode() + " " + error.getDescription(), null);
            }

            public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
                sslErrorHandler.proceed();
                LiveCloudActivity.this.logger.debug("SDK.WebViewError", "sslError: " + sslError.getPrimaryError() + " " + sslError.getUrl(), null);
            }
        };
    }

    private WebChromeClient createWebChromeClient() {
        return new WebChromeClient(){

            public void onPermissionRequest(PermissionRequest request) {
                LiveCloudActivity.this.runOnUiThread(() -> {
                    block8: for (String permission2 : request.getResources()) {
                        LiveCloudActivity.this.myRequest = request;
                        switch (permission2) {
                            case "android.webkit.resource.AUDIO_CAPTURE": {
                                LiveCloudActivity.this.askForPermission("android.permission.RECORD_AUDIO");
                                continue block8;
                            }
                            case "android.webkit.resource.VIDEO_CAPTURE": {
                                LiveCloudActivity.this.askForPermission("android.permission.CAMERA");
                            }
                        }
                    }
                });
            }

            public boolean onJsPrompt(WebView webView, String s, String s1, String s2, JsPromptResult jsPromptResult) {
                jsPromptResult.cancel();
                return true;
            }

            public boolean onJsConfirm(WebView webView, String s, String s1, JsResult jsResult) {
                jsResult.cancel();
                return true;
            }

            public boolean onJsAlert(WebView webView, String s, String s1, JsResult jsResult) {
                jsResult.cancel();
                return true;
            }

            public boolean onJsBeforeUnload(WebView webView, String s, String s1, JsResult jsResult) {
                jsResult.cancel();
                return true;
            }

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                if (LiveCloudActivity.this.enterDurationSecond() < 10L && consoleMessage.messageLevel().equals((Object)ConsoleMessage.MessageLevel.ERROR)) {
                    LiveCloudActivity.this.logger.error("SDK.WebViewError", "ConsoleMessage: " + consoleMessage.message(), null);
                }
                return super.onConsoleMessage(consoleMessage);
            }
        };
    }

    @JavascriptInterface
    public void connect() {
        this.connect = true;
        LiveCloudUtils.clearTimeoutTimes((Context)this, this.roomId);
    }

    @JavascriptInterface
    public void fullscreen() {
        this.runOnUiThread(() -> {
            this.isFullscreen = this.isFullscreen == false;
            if (this.isFullscreen.booleanValue()) {
                this.setWindowFullScreen();
            } else {
                this.setWindowShrinkScreen();
            }
        });
    }

    @JavascriptInterface
    public String getDeviceInfo() {
        Map<String, Object> info = LiveCloudUtils.deviceInfo((Context)this);
        return new JSONObject(info).toString();
    }

    @JavascriptInterface
    public void exit() {
        this.runOnUiThread(() -> this.finish());
    }

    private void setWindowFullScreen() {
        this.setRequestedOrientation(0);
        LiveCloudUtils.fullScreen(this, true);
    }

    private void setWindowShrinkScreen() {
        this.setRequestedOrientation(1);
        LiveCloudUtils.fullScreen(this, false);
    }

    private long enterDurationSecond() {
        return (System.currentTimeMillis() - this.enterTimestamp) / 1000L;
    }

    private void askForPermission(String permission2) {
        if (ContextCompat.checkSelfPermission((Context)this, (String)permission2) != 0) {
            this.requestPermissionLauncher.launch((Object)permission2);
        }
    }
}

