/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.livecloudsdk;

import com.codeages.livecloudsdk.HttpThreadPoolUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class LiveCloudHttpClient {
    public static void get(String requestUrl, OnRequestCallBack callBack) {
        LiveCloudHttpClient.get(requestUrl, 3000, callBack);
    }

    public static void get(String requestUrl, int timeout, OnRequestCallBack callBack) {
        HttpThreadPoolUtils.execute(() -> LiveCloudHttpClient.getRequest(requestUrl, timeout, callBack));
    }

    public static void post(String requestUrl, String params, OnRequestCallBack callBack) {
        LiveCloudHttpClient.post(requestUrl, params, 3000, callBack);
    }

    public static void post(String requestUrl, String params, int timeout, OnRequestCallBack callBack) {
        HttpThreadPoolUtils.execute(() -> LiveCloudHttpClient.postRequest(requestUrl, params, timeout, callBack));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getRequest(String requestUrl, int timeout, OnRequestCallBack callBack) {
        String successMessage = null;
        String errorMessage = null;
        InputStream inputStream = null;
        ByteArrayOutputStream baos = null;
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.connect();
            int contentLength = connection.getContentLength();
            if (connection.getResponseCode() == 200) {
                int readLen;
                inputStream = connection.getInputStream();
                baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                while ((readLen = inputStream.read(bytes)) != -1) {
                    baos.write(bytes, 0, readLen);
                }
                successMessage = baos.toString();
            } else {
                errorMessage = "\u8bf7\u6c42\u5931\u8d25 code:" + connection.getResponseCode();
            }
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                errorMessage = e.getMessage();
                e.printStackTrace();
            }
        }
        if (callBack != null) {
            callBack.onCompletion(successMessage, errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postRequest(String requestUrl, String params, int timeout, OnRequestCallBack callBack) {
        String successMessage = null;
        String errorMessage = null;
        InputStream inputStream = null;
        ByteArrayOutputStream baos = null;
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);
            out.write(params);
            out.flush();
            connection.connect();
            int contentLength = connection.getContentLength();
            if (connection.getResponseCode() == 200) {
                int readLen;
                inputStream = connection.getInputStream();
                baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                while ((readLen = inputStream.read(bytes)) != -1) {
                    baos.write(bytes, 0, readLen);
                }
                successMessage = baos.toString();
            } else {
                errorMessage = "\u8bf7\u6c42\u5931\u8d25 code:" + connection.getResponseCode();
            }
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                errorMessage = e.getMessage();
                e.printStackTrace();
            }
        }
        if (callBack != null) {
            callBack.onCompletion(successMessage, errorMessage);
        }
    }

    public static interface OnRequestCallBack {
        public void onCompletion(String var1, String var2);
    }
}

