/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.livecloudsdk;

import com.blankj.utilcode.util.FileUtils;
import com.blankj.utilcode.util.GsonUtils;
import com.blankj.utilcode.util.PathUtils;
import com.codeages.livecloudsdk.bean.ReplayInfo;
import com.codeages.livecloudsdk.bean.ReplayMetas;
import com.tencent.mmkv.MMKV;
import java.io.File;

public class LiveCloudLocal {
    public static final int LOCAL_HTTP_PORT = 20100;
    public static final String LIVE_CLOUD_REPLAY_PATH = "/live_cloud_replay";
    public static final String LIVE_CLOUD_PLAYER_PATH = "/live_cloud_player";
    public static final String PLAYER_VERSION = "player_version";
    public static final String LIVE_CLOUD_REPLAY_DB = "live_cloud_replay_db";
    public static final String LIVE_CLOUD_REPLAY_METAS_URL = "live_cloud_replay_metas_url";

    public static String getPlayerVersion() {
        MMKV kv = MMKV.defaultMMKV();
        return kv.decodeString(PLAYER_VERSION, "-1");
    }

    public static void setPlayerVersion(String version) {
        MMKV kv = MMKV.defaultMMKV();
        kv.encode(PLAYER_VERSION, version);
    }

    public static void removePlayerVersion() {
        MMKV kv = MMKV.defaultMMKV();
        kv.remove(PLAYER_VERSION);
    }

    public static void setReplay(String key, ReplayMetas replayMetas) {
        MMKV kv = MMKV.mmkvWithID((String)LIVE_CLOUD_REPLAY_DB, (int)2);
        kv.encode(key, GsonUtils.toJson((Object)replayMetas));
    }

    public static void removeReplay(String key) {
        MMKV kv = MMKV.mmkvWithID((String)LIVE_CLOUD_REPLAY_DB, (int)2);
        kv.remove(key);
    }

    public static ReplayMetas getReplay(String key) {
        MMKV kv = MMKV.mmkvWithID((String)LIVE_CLOUD_REPLAY_DB, (int)2);
        return (ReplayMetas)GsonUtils.fromJson((String)kv.decodeString(key), ReplayMetas.class);
    }

    public static void setReplayStatus(String key, int status) {
        MMKV kv = MMKV.mmkvWithID((String)LIVE_CLOUD_REPLAY_DB, (int)2);
        ReplayMetas replayMetas = (ReplayMetas)GsonUtils.fromJson((String)kv.decodeString(key), ReplayMetas.class);
        replayMetas.setStatus(status);
        kv.encode(key, GsonUtils.toJson((Object)replayMetas));
    }

    public static int getReplayStatus(String key) {
        MMKV kv = MMKV.mmkvWithID((String)LIVE_CLOUD_REPLAY_DB, (int)2);
        ReplayMetas replayMetas = (ReplayMetas)GsonUtils.fromJson((String)kv.decodeString(key), ReplayMetas.class);
        if (replayMetas == null) {
            return ReplayInfo.Status.NONE.ordinal();
        }
        return replayMetas.getStatus();
    }

    public static void setMetasUrl(String key, String metasUrl) {
        MMKV kv = MMKV.mmkvWithID((String)LIVE_CLOUD_REPLAY_METAS_URL, (int)2);
        kv.encode(key, metasUrl);
    }

    public static String getMetasUrl(String key) {
        MMKV kv = MMKV.mmkvWithID((String)LIVE_CLOUD_REPLAY_METAS_URL, (int)2);
        return kv.decodeString(key, "");
    }

    public static void removeMetasUrl(String key) {
        MMKV kv = MMKV.mmkvWithID((String)LIVE_CLOUD_REPLAY_METAS_URL, (int)2);
        kv.remove(key);
    }

    public static String getPlayerFilesUrl(String playerBaseUri, String playerFileName) {
        return playerBaseUri + "/" + playerFileName;
    }

    public static File getReplayDirectory(String roomId) {
        File replayDirectory = new File(LiveCloudLocal.getLiveCloudReplayPath() + "/" + roomId);
        if (!replayDirectory.exists()) {
            FileUtils.createOrExistsDir((File)replayDirectory);
        }
        return replayDirectory;
    }

    public static File getPlayerDirectory() {
        File playerDirectory = new File(LiveCloudLocal.getLiveCloudPlayerPath());
        if (!playerDirectory.exists()) {
            FileUtils.createOrExistsDir((File)playerDirectory);
        }
        return playerDirectory;
    }

    private static String getLiveCloudPlayerPath() {
        return PathUtils.getExternalAppFilesPath() + LIVE_CLOUD_PLAYER_PATH;
    }

    private static String getLiveCloudReplayPath() {
        return PathUtils.getExternalAppFilesPath() + LIVE_CLOUD_REPLAY_PATH;
    }
}

