/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.livecloudsdk;

import android.os.CountDownTimer;
import com.codeages.livecloudsdk.LiveCloudHttpClient;
import com.codeages.livecloudsdk.LiveCloudUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

public class LiveCloudLogger {
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String WARN = "WARN";
    public static final String ERROR = "ERROR";
    private final String mLogUrl;
    private final Map<String, Object> jwt;
    private List<Map<String, Object>> logs;
    private final String logIdPrefix = LiveCloudUtils.randomString(8) + "_";
    private long logId = 1L;
    private final CountDownTimer countDownTimer = new CountDownTimer(10000L, 10000L){

        public void onTick(long l) {
        }

        public void onFinish() {
            LiveCloudLogger.this.postLog();
        }
    };

    public LiveCloudLogger(String logUrl, String roomUrl) {
        this.mLogUrl = logUrl != null ? logUrl : "https://live-log.edusoho.com/collect";
        this.jwt = LiveCloudUtils.parseJwt(roomUrl);
        this.logs = new ArrayList<Map<String, Object>>();
    }

    public LiveCloudLogger(final Long roomId, final Long userId, String logUrl) {
        this.mLogUrl = logUrl != null ? logUrl : "https://live-log.edusoho.com/collect";
        this.jwt = new HashMap<String, Object>(){
            {
                this.put("rid", roomId);
                this.put("uid", userId);
            }
        };
        this.logs = new ArrayList<Map<String, Object>>();
    }

    protected void debug(String action, String message, Map<String, Object> context) {
        this.pushLog(DEBUG, action, message, context);
    }

    protected void info(String action, String message, Map<String, Object> context) {
        this.pushLog(INFO, action, message, context);
    }

    protected void warn(String action, String message, Map<String, Object> context) {
        this.pushLog(WARN, action, message, context);
    }

    protected void error(String action, String message, Map<String, Object> context) {
        this.pushLog(ERROR, action, message, context);
    }

    private void pushLog(final String level, final String action, String message, Map<String, Object> context) {
        String dateString = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault()).format(new Date());
        HashMap<String, Object> log = new HashMap<String, Object>();
        log.put("@timestamp", dateString);
        log.put("message", "[event] @(" + action + ")" + (message != null ? ", " + message : ""));
        log.put("event", new HashMap<String, String>(){
            {
                this.put("action", action);
                this.put("dataset", "livecloud.client");
                this.put("id", LiveCloudLogger.this.logIdPrefix + LiveCloudLogger.this.logId);
                this.put("kind", "event");
            }
        });
        log.put("log", new HashMap<String, String>(){
            {
                this.put("level", level);
            }
        });
        log.put("room", new HashMap<String, Object>(){
            {
                this.put("id", LiveCloudLogger.this.jwt.get("rid"));
            }
        });
        log.put("user", new HashMap<String, Object>(){
            {
                this.put("id", LiveCloudLogger.this.jwt.get("uid"));
                this.put("name", LiveCloudLogger.this.jwt.get("name") != null ? LiveCloudLogger.this.jwt.get("name") : "");
                this.put("roles", new Object[]{LiveCloudLogger.this.jwt.get("role") != null ? LiveCloudLogger.this.jwt.get("role") : ""});
            }
        });
        if (context != null) {
            log.putAll(context);
        }
        ++this.logId;
        if (this.logs.size() < 500) {
            this.logs.add(log);
        }
        this.countDownTimer.start();
    }

    private void postLog() {
        if (this.logs.size() == 0) {
            return;
        }
        final int countNum = Math.min(this.logs.size(), 100);
        final String dateString = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault()).format(new Date());
        HashMap<String, Object> payload = new HashMap<String, Object>(){
            {
                this.put("@timestamp", dateString);
                this.put("logs", LiveCloudLogger.this.logs.subList(0, countNum));
            }
        };
        this.logs = this.logs.subList(countNum, this.logs.size());
        LiveCloudHttpClient.post(this.mLogUrl, new JSONObject((Map)payload).toString(), 6000, null);
    }
}

