/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.livecloudsdk;

import android.content.Context;
import android.text.TextUtils;
import com.blankj.utilcode.util.FileUtils;
import com.blankj.utilcode.util.LogUtils;
import com.codeages.livecloudsdk.DownloadPlayerListener;
import com.codeages.livecloudsdk.DownloadReplayListener;
import com.codeages.livecloudsdk.LiveCloudLocal;
import com.codeages.livecloudsdk.LiveCloudLogger;
import com.codeages.livecloudsdk.LiveReplayActivity;
import com.codeages.livecloudsdk.ReplayListener;
import com.codeages.livecloudsdk.api.CloudApi;
import com.codeages.livecloudsdk.bean.ParseReplayResult;
import com.codeages.livecloudsdk.bean.PlayerInfo;
import com.codeages.livecloudsdk.bean.ReplayError;
import com.codeages.livecloudsdk.bean.ReplayInfo;
import com.codeages.livecloudsdk.bean.ReplayMetaItem;
import com.codeages.livecloudsdk.bean.ReplayMetas;
import com.codeages.livecloudsdk.http.LiveHttpClient;
import com.codeages.livecloudsdk.http.RxUtils;
import com.codeages.livecloudsdk.server.HttpServerFactory;
import com.liulishuo.okdownload.DownloadListener;
import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.StatusUtil;
import com.liulishuo.okdownload.core.dispatcher.DownloadDispatcher;
import com.tencent.mmkv.MMKV;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import rx.Emitter;
import rx.Observable;
import rx.Subscriber;

public class LiveCloudSDK {
    public static final String FetchStarted = "OfflineReplay.FetchStarted";
    public static final String FetchCancelled = "OfflineReplay.FetchCancelled";
    public static final String FetchFinished = "OfflineReplay.FetchFinished";
    public static final String Deleted = "OfflineReplay.Deleted";
    public static final String DeletedAll = "OfflineReplay.DeletedAll";
    public static final String FetchFailed = "OfflineReplay.FetchFailed";
    public static final String FetchFileError = "OfflineReplay.FetchFileError";
    public static final String Enter = "OfflineReplay.Enter";
    public static final String WebViewError = "OfflineReplay.WebViewError";
    private final String mKey;
    private final String mDownloadUrl;
    private final String mToken;
    private final String mUserId;
    private final String mUsername;
    private final ReplayListener mReplayListener;

    private LiveCloudSDK(Builder builder) {
        this.mKey = builder.key;
        this.mDownloadUrl = builder.downloadUrl;
        this.mToken = builder.token;
        this.mUserId = builder.userId;
        this.mUsername = builder.username;
        this.mReplayListener = builder.replayListener;
    }

    public static void init(Context context) {
        MMKV.initialize((Context)context);
        DownloadDispatcher.setMaxParallelRunningCount((int)5);
        LogUtils.getConfig().setGlobalTag("LiveCloudSDK");
        LogUtils.getConfig().setBorderSwitch(true);
    }

    public void playOfflineReplay(Context context) {
        HttpServerFactory.getInstance().start();
        if (TextUtils.isEmpty((CharSequence)this.mKey)) {
            throw new RuntimeException("Key is not null!");
        }
        ReplayMetas replayMetas = LiveCloudLocal.getReplay(this.mKey);
        if (replayMetas == null) {
            this.mReplayListener.onError(new ReplayError(10100));
            return;
        }
        String playUrl = "http://127.0.0.1:20100/live_cloud_player/index.html#/replay/22956?offline=1&roomName=" + replayMetas.getRoomName() + "&metasUrl=" + LiveCloudLocal.getMetasUrl(this.mKey) + "&userId=" + this.mUserId + "&userName=" + this.mUsername + "&showChat=" + replayMetas.getShowChat() + "&duration=" + replayMetas.getDuration() + "&proxyUrl=127.0.0.1:" + 20100 + "/live_cloud_replay/" + replayMetas.getRoomId();
        LiveReplayActivity.launch(context, playUrl, replayMetas.getRoomId() + "", this.mUserId);
    }

    public void startFetchReplay() {
        Observable observable = new LiveHttpClient().addToken(this.mToken).createApi(CloudApi.class).getReplayMetas(this.mDownloadUrl).compose(RxUtils.switch2Main());
        observable.subscribe((Subscriber)new Subscriber<ReplayMetas>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtils.e((Object[])new Object[]{e.getMessage()});
            }

            public void onNext(ReplayMetas replayMetas) {
                LiveCloudLocal.setReplay(LiveCloudSDK.this.mKey, replayMetas);
                LiveCloudSDK.this.parsePlayerAndReplay(replayMetas);
            }
        });
    }

    public void cancelFetchReplay() {
        ReplayMetas replayMetas = LiveCloudLocal.getReplay(this.mKey);
        if (replayMetas != null) {
            LogUtils.d((Object[])new Object[]{"stop", "cancelFetchReplay: "});
            replayMetas.setStatus(ReplayInfo.Status.PAUSE.ordinal());
            LiveCloudLocal.setReplay(this.mKey, replayMetas);
            new LiveCloudLogger(Long.parseLong(replayMetas.getRoomId() + ""), Long.parseLong(this.mUserId), null).info(FetchCancelled, "\u53d6\u6d88\u4e0b\u8f7d\u56de\u653e\u7f13\u5b58", null);
        }
    }

    public void deleteReplay() {
        ReplayMetas replayMetas = LiveCloudLocal.getReplay(this.mKey);
        if (replayMetas != null) {
            int roomId = replayMetas.getRoomId();
            FileUtils.deleteAllInDir((File)LiveCloudLocal.getReplayDirectory(roomId + ""));
            FileUtils.delete((File)LiveCloudLocal.getReplayDirectory(roomId + ""));
            new LiveCloudLogger(Long.parseLong(replayMetas.getRoomId() + ""), Long.parseLong(this.mUserId), null).info(Deleted, "\u5220\u9664\u5df2\u4e0b\u8f7d\u56de\u653e\u7f13\u5b58", null);
        } else {
            this.mReplayListener.onError(new ReplayError(10100));
        }
        LiveCloudLocal.removeReplay(this.mKey);
        LiveCloudLocal.removeMetasUrl(this.mKey);
    }

    public String getReplaySize() {
        String replaySize = "";
        ReplayMetas replayMetas = LiveCloudLocal.getReplay(this.mKey);
        if (replayMetas != null) {
            int roomId = replayMetas.getRoomId();
            replaySize = FileUtils.getSize((File)LiveCloudLocal.getReplayDirectory(roomId + ""));
        }
        return replaySize;
    }

    public void updatePlayer() {
        LiveCloudLocal.removePlayerVersion();
        FileUtils.deleteAllInDir((File)LiveCloudLocal.getPlayerDirectory());
        final ReplayMetas[] finalReplayMetas = new ReplayMetas[1];
        new LiveHttpClient().addToken(this.mToken).createApi(CloudApi.class).getReplayMetas(this.mDownloadUrl).flatMap(replayMetas -> {
            finalReplayMetas[0] = replayMetas;
            return new LiveHttpClient().createApi(CloudApi.class).getPlayerInfo(replayMetas.getPlayerUrl());
        }).compose(RxUtils.switch2Main()).subscribe((Subscriber)new Subscriber<PlayerInfo>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(PlayerInfo playerInfo) {
                LiveCloudSDK.this.fetchPlayer(playerInfo, finalReplayMetas[0], null, false);
            }
        });
    }

    public int getReplayStatus() {
        if (TextUtils.isEmpty((CharSequence)this.mKey)) {
            throw new RuntimeException("Key is not null!");
        }
        return LiveCloudLocal.getReplayStatus(this.mKey);
    }

    private void parsePlayerAndReplay(final ReplayMetas replayMetas) {
        Observable<PlayerInfo> playerObservable = new LiveHttpClient().createApi(CloudApi.class).getPlayerInfo(replayMetas.getPlayerUrl());
        Observable<List<ReplayMetaItem>> replayObservable = new LiveHttpClient().createApi(CloudApi.class).getReplayInfo(replayMetas.getDataUrl());
        Observable.combineLatest(playerObservable, replayObservable, (playerInfo, replayMetaItems) -> new ParseReplayResult((PlayerInfo)playerInfo, replayMetas, (List<ReplayMetaItem>)replayMetaItems, true)).compose(RxUtils.switch2Main()).subscribe((Subscriber)new Subscriber<ParseReplayResult>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(ParseReplayResult result) {
                if (!LiveCloudLocal.getPlayerVersion().equals(result.getPlayerInfo().getVersion())) {
                    LiveCloudSDK.this.fetchPlayer(result.getPlayerInfo(), replayMetas, result.getReplayMetaItems(), result.isSign());
                } else {
                    LiveCloudSDK.this.fetchReplay(result.getReplayMetaItems(), replayMetas);
                }
            }
        });
    }

    private void fetchPlayer(PlayerInfo playerInfo, ReplayMetas replayMetas, List<ReplayMetaItem> replayMetaItems, boolean sign) {
        this.mReplayListener.onPlayerReady(replayMetas, playerInfo.getUrls().size());
        ArrayList<DownloadTask> downloadTasks = new ArrayList<DownloadTask>(playerInfo.getUrls().size());
        for (String url : playerInfo.getUrls()) {
            downloadTasks.add(this.downloadTaskBuild(LiveCloudLocal.getPlayerFilesUrl(replayMetas.getPlayerBaseUri(), url), new File(LiveCloudLocal.getPlayerDirectory() + "/" + url)));
        }
        AtomicInteger index = new AtomicInteger();
        Observable.interval((long)200L, (TimeUnit)TimeUnit.MILLISECONDS).flatMap(o -> Observable.create(emitter -> emitter.onNext((Object)true), (Emitter.BackpressureMode)Emitter.BackpressureMode.BUFFER)).takeWhile(isCancel -> index.get() < playerInfo.getUrls().size()).compose(RxUtils.switch2Main()).subscribe(Void2 -> {
            DownloadTask downloadTask = (DownloadTask)downloadTasks.get(index.get());
            StatusUtil.Status taskStatus = StatusUtil.getStatus((DownloadTask)downloadTask);
            if (taskStatus == StatusUtil.Status.UNKNOWN || taskStatus == StatusUtil.Status.IDLE) {
                DownloadPlayerListener downloadPlayerListener = new DownloadPlayerListener(replayMetas, index.get() + 1, this.mReplayListener);
                downloadTask.enqueue((DownloadListener)downloadPlayerListener);
            } else if (taskStatus == StatusUtil.Status.COMPLETED) {
                index.getAndIncrement();
                if (index.get() == playerInfo.getUrls().size()) {
                    this.mReplayListener.onPlayerFinish(replayMetas);
                    LiveCloudLocal.setPlayerVersion(playerInfo.getVersion());
                    if (sign) {
                        this.fetchReplay(replayMetaItems, replayMetas);
                    }
                }
            }
        });
    }

    private void fetchReplay(final List<ReplayMetaItem> replayMetaItems, final @NotNull ReplayMetas replayMetas) {
        final ArrayList<DownloadTask> downloadTasks = new ArrayList<DownloadTask>();
        for (ReplayMetaItem replayMetaItem : replayMetaItems) {
            for (String url : replayMetaItem.getUrls()) {
                if (TextUtils.isEmpty((CharSequence)url)) continue;
                String replayBaseUrl = this.getBaseReplayUri(replayMetaItem.getType(), replayMetas);
                downloadTasks.add(this.downloadTaskBuild(replayBaseUrl + "/" + url, new File(LiveCloudLocal.getReplayDirectory(replayMetas.getRoomId() + "") + "/" + url)));
            }
        }
        this.mReplayListener.onReady(replayMetas, downloadTasks.size());
        new LiveCloudLogger(Long.parseLong(replayMetas.getRoomId() + ""), Long.parseLong(this.mUserId), null).info(FetchStarted, "\u5f00\u59cb\u4e0b\u8f7d\u56de\u653e\u7f13\u5b58", null);
        final int taskSum = downloadTasks.size();
        final AtomicInteger index = new AtomicInteger();
        LiveCloudLocal.setReplayStatus(this.mKey, ReplayInfo.Status.DOWNLOADING.ordinal());
        Observable.interval((long)500L, (TimeUnit)TimeUnit.MILLISECONDS).flatMap(o -> Observable.create(emitter -> emitter.onNext((Object)true), (Emitter.BackpressureMode)Emitter.BackpressureMode.BUFFER)).takeWhile(isCancel -> {
            LogUtils.d((Object[])new Object[]{"stop", "takeWhile: "});
            int status = LiveCloudLocal.getReplayStatus(this.mKey);
            return index.get() < taskSum && status == ReplayInfo.Status.DOWNLOADING.ordinal();
        }).compose(RxUtils.switch2Main()).subscribe((Subscriber)new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtils.d((Object[])new Object[]{"stop", "onError: "});
                HashMap<String, Object> errorMap = new HashMap<String, Object>();
                errorMap.put("error", e);
                new LiveCloudLogger(Long.parseLong(replayMetas.getRoomId() + ""), Long.parseLong(LiveCloudSDK.this.mUserId), null).error(LiveCloudSDK.FetchFailed, "\u4e0b\u8f7d\u56de\u653e\u7f13\u5b58\u5931\u8d25", errorMap);
            }

            public void onNext(Boolean aBoolean) {
                LogUtils.d((Object[])new Object[]{"stop", "onNext: "});
                DownloadTask downloadTask = (DownloadTask)downloadTasks.get(index.get());
                StatusUtil.Status taskStatus = StatusUtil.getStatus((DownloadTask)downloadTask);
                if (taskStatus == StatusUtil.Status.UNKNOWN || taskStatus == StatusUtil.Status.IDLE) {
                    DownloadReplayListener downloadReplayListener = new DownloadReplayListener(replayMetas, index.get() + 1, LiveCloudSDK.this.mUserId, LiveCloudSDK.this.mReplayListener);
                    downloadTask.enqueue((DownloadListener)downloadReplayListener);
                } else if (taskStatus == StatusUtil.Status.COMPLETED) {
                    index.getAndIncrement();
                    try {
                        if (index.get() == taskSum) {
                            LiveCloudSDK.this.mReplayListener.onFinish(replayMetas);
                            new LiveCloudLogger(Long.parseLong(replayMetas.getRoomId() + ""), Long.parseLong(LiveCloudSDK.this.mUserId), null).info(LiveCloudSDK.FetchFinished, "\u5b8c\u6210\u4e0b\u8f7d\u56de\u653e\u7f13\u5b58", null);
                            LiveCloudLocal.setReplayStatus(LiveCloudSDK.this.mKey, ReplayInfo.Status.COMPLETED.ordinal());
                            LiveCloudLocal.setMetasUrl(LiveCloudSDK.this.mKey, LiveCloudSDK.this.getMetasUrl(replayMetaItems));
                        }
                    }
                    catch (Exception ex) {
                        LogUtils.e((Object[])new Object[]{ex.getMessage()});
                    }
                }
            }
        });
    }

    private String getMetasUrl(List<ReplayMetaItem> replayMetaItems) {
        String metasUrl = "";
        for (ReplayMetaItem replayMetaItem : replayMetaItems) {
            if (!"metas".equals(replayMetaItem.getType()) || replayMetaItem.getUrls().size() <= 0) continue;
            metasUrl = replayMetaItem.getUrls().get(0);
            break;
        }
        return metasUrl;
    }

    private String getBaseReplayUri(String type, ReplayMetas replayMetas) {
        switch (type) {
            case "video": {
                return replayMetas.getVideoBaseUri();
            }
            case "document": {
                return replayMetas.getDocumentBaseUri();
            }
        }
        return replayMetas.getDataBaseUri();
    }

    private DownloadTask downloadTaskBuild(String url, File file) {
        return new DownloadTask.Builder(url, file).setMinIntervalMillisCallbackProcess(100).setConnectionCount(1).setBreakpointEnabled(false).build();
    }

    public static class Builder {
        private String key;
        private String downloadUrl;
        private String token;
        private String userId;
        private String username;
        private ReplayListener replayListener;

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public Builder setUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setReplayListener(ReplayListener replayListener) {
            this.replayListener = replayListener;
            return this;
        }

        public LiveCloudSDK build() {
            if (this.replayListener == null) {
                throw new RuntimeException("ReplayListener is null");
            }
            return new LiveCloudSDK(this);
        }
    }
}

