/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.livecloudsdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.WindowManager;
import android.webkit.JavascriptInterface;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.widget.ContentLoadingProgressBar;
import com.codeages.livecloudsdk.LiveCloudLogger;
import com.codeages.livecloudsdk.LiveCloudUtils;
import com.codeages.livecloudsdk.R;
import com.codeages.livecloudsdk.server.HttpServerFactory;
import com.tencent.smtt.export.external.interfaces.ConsoleMessage;
import com.tencent.smtt.export.external.interfaces.JsPromptResult;
import com.tencent.smtt.export.external.interfaces.JsResult;
import com.tencent.smtt.export.external.interfaces.SslError;
import com.tencent.smtt.export.external.interfaces.SslErrorHandler;
import com.tencent.smtt.export.external.interfaces.WebResourceError;
import com.tencent.smtt.export.external.interfaces.WebResourceRequest;
import com.tencent.smtt.sdk.QbSdk;
import com.tencent.smtt.sdk.TbsListener;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebSettings;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;
import java.util.Map;
import org.json.JSONObject;

public class LiveReplayActivity
extends AppCompatActivity {
    private static final String JSInterface = "LiveCloudBridge";
    protected WebView webView;
    private Boolean connect = false;
    private Boolean isFullscreen = false;
    private ContentLoadingProgressBar loadingView;
    private long startTimePoint;
    private String mUrl;
    private String mRoomId;
    private String mUserId;

    public static void launch(Context context, String url, String roomId, String userId) {
        Intent intent = new Intent(context, LiveReplayActivity.class);
        intent.putExtra("url", url);
        intent.putExtra("roomId", roomId);
        intent.putExtra("UserId", userId);
        context.startActivity(intent);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(R.style.LiveCloudTheme);
        this.setContentView(R.layout.activity_live_cloud);
        this.getWindow().setFormat(-3);
        this.getWindow().addFlags(128);
        this.mUrl = this.getIntent().getStringExtra("url");
        this.mRoomId = this.getIntent().getStringExtra("roomId");
        this.mUserId = this.getIntent().getStringExtra("UserId");
        this.loadingView = (ContentLoadingProgressBar)this.findViewById(R.id.loadingView);
        this.loadingView.show();
        this.createWebView();
        new LiveCloudLogger(Long.parseLong(this.mRoomId), Long.parseLong(this.mUserId), null).info("OfflineReplay.Enter", "\u8fdb\u5165\u89c2\u770b\u56de\u653e\u7f13\u5b58", null);
        this.startTimePoint = System.currentTimeMillis();
        this.loadRoomURL(this.mUrl);
    }

    protected void onResume() {
        super.onResume();
        if (this.webView != null) {
            this.webView.onResume();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.webView != null) {
            this.webView.onPause();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.webView != null) {
            this.webView.removeJavascriptInterface(JSInterface);
            this.webView.setWebViewClient(null);
            this.webView.setWebChromeClient(null);
            this.webView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
            this.webView.clearHistory();
            this.webView.destroy();
            this.webView = null;
        }
        HttpServerFactory.getInstance().stop();
    }

    private void loadRoomURL(String url) {
        this.webView.loadUrl(url);
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "JavascriptInterface"})
    private void createWebView() {
        QbSdk.setTbsListener((TbsListener)new TbsListener(){

            public void onDownloadFinish(int i) {
            }

            public void onInstallFinish(int i) {
            }

            public void onDownloadProgress(int i) {
            }
        });
        WebView.setWebContentsDebuggingEnabled((boolean)true);
        this.webView = (WebView)this.findViewById(R.id.webView);
        this.webView.setWebViewClient(this.createWebViewClient());
        this.webView.setWebChromeClient(this.createWebChromeClient());
        this.webView.addJavascriptInterface((Object)this, JSInterface);
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setCacheMode(-1);
        webSettings.setDefaultTextEncodingName("utf-8");
        webSettings.setDomStorageEnabled(true);
        webSettings.setMixedContentMode(0);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setMediaPlaybackRequiresUserGesture(false);
    }

    private WebViewClient createWebViewClient() {
        return new WebViewClient(){

            public void onPageFinished(WebView webView, String s) {
                super.onPageFinished(webView, s);
                LiveReplayActivity.this.loadingView.hide();
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
            }

            public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
                sslErrorHandler.proceed();
            }
        };
    }

    private WebChromeClient createWebChromeClient() {
        return new WebChromeClient(){

            public boolean onJsPrompt(WebView webView, String s, String s1, String s2, JsPromptResult jsPromptResult) {
                jsPromptResult.cancel();
                return true;
            }

            public boolean onJsConfirm(WebView webView, String s, String s1, JsResult jsResult) {
                jsResult.cancel();
                return true;
            }

            public boolean onJsAlert(WebView webView, String s, String s1, JsResult jsResult) {
                jsResult.cancel();
                return true;
            }

            public boolean onJsBeforeUnload(WebView webView, String s, String s1, JsResult jsResult) {
                jsResult.cancel();
                return true;
            }

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                if ((System.currentTimeMillis() - LiveReplayActivity.this.startTimePoint) / 1000L < 10L) {
                    new LiveCloudLogger(Long.parseLong(LiveReplayActivity.this.mRoomId), Long.parseLong(LiveReplayActivity.this.mUserId), null).info("OfflineReplay.WebViewError", "\u89c2\u770b\u56de\u653e\u7f13\u5b58Web\u62a5\u9519", null);
                }
                return super.onConsoleMessage(consoleMessage);
            }
        };
    }

    @JavascriptInterface
    public void connect() {
        this.connect = true;
    }

    @JavascriptInterface
    public void fullscreen() {
        this.runOnUiThread(() -> {
            this.isFullscreen = this.isFullscreen == false;
            if (this.isFullscreen.booleanValue()) {
                this.setWindowFullScreen();
            } else {
                this.setWindowShrinkScreen();
            }
        });
    }

    @JavascriptInterface
    public String getDeviceInfo() {
        Map<String, Object> info = LiveCloudUtils.deviceInfo((Context)this);
        return new JSONObject(info).toString();
    }

    @JavascriptInterface
    public void exit() {
        this.runOnUiThread(() -> this.finish());
    }

    private void setWindowFullScreen() {
        this.setRequestedOrientation(0);
        this.fullScreen(true);
    }

    private void setWindowShrinkScreen() {
        this.setRequestedOrientation(1);
        this.fullScreen(false);
    }

    public void fullScreen(boolean isFull) {
        if (isFull) {
            this.hideNavigationBar();
            if (Build.VERSION.SDK_INT >= 28) {
                WindowManager.LayoutParams lp = this.getWindow().getAttributes();
                lp.layoutInDisplayCutoutMode = 1;
                this.getWindow().setAttributes(lp);
            }
            this.getWindow().getDecorView().setSystemUiVisibility(5894);
            this.getWindow().addFlags(1024);
        } else {
            this.showNavigationBar();
            this.getWindow().clearFlags(1024);
        }
    }

    private void hideNavigationBar() {
        View decorView = this.getWindow().getDecorView();
        int uiOptions = 2;
        decorView.setSystemUiVisibility(uiOptions);
    }

    private void showNavigationBar() {
        View decorView = this.getWindow().getDecorView();
        int uiOptions = 0;
        decorView.setSystemUiVisibility(uiOptions);
    }
}

