/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.livecloudsdk.cache;

import com.blankj.utilcode.util.LogUtils;
import java.io.IOException;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpServerConnection;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpService;

public class WorkThread
extends Thread {
    private final HttpService httpservice;
    private final HttpServerConnection conn;

    public WorkThread(HttpService httpservice, HttpServerConnection conn) {
        this.httpservice = httpservice;
        this.conn = conn;
    }

    @Override
    public void run() {
        BasicHttpContext context = new BasicHttpContext();
        try {
            while (!Thread.interrupted() && this.conn.isOpen()) {
                this.httpservice.handleRequest(this.conn, (HttpContext)context);
            }
        }
        catch (ConnectionClosedException ex) {
            System.err.println("Client closed connection");
        }
        catch (IOException ex) {
            LogUtils.e((Object[])new Object[]{"IOException:" + ex.getMessage()});
        }
        catch (HttpException ex) {
            LogUtils.e((Object[])new Object[]{"Unrecoverable HTTP protocol violation:" + ex.getMessage()});
        }
        catch (Exception ex) {
            LogUtils.e((Object[])new Object[]{"Exception:" + ex.getMessage()});
        }
        finally {
            try {
                this.conn.shutdown();
                this.conn.close();
            }
            catch (IOException ex) {}
        }
        LogUtils.d((Object[])new Object[]{"WorkThread:close"});
    }
}

