/*
 * Decompiled with CFR 0.152.
 */
package com.codeages.livecloudsdk.server;

import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.PathUtils;
import fi.iki.elonen.NanoHTTPD;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class HttpServer
extends NanoHTTPD {
    public HttpServer(int port) {
        super(port);
    }

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        NanoHTTPD.Response response = null;
        try {
            String url = session.getUri();
            LogUtils.d((Object[])new Object[]{url});
            String[] split1 = url.split("[.]");
            String suffix = split1.length > 1 ? split1[split1.length - 1] : "";
            String filePath = "";
            if (url.contains("/live_cloud_player")) {
                filePath = PathUtils.getExternalAppFilesPath() + url;
            } else if (url.contains("/live_cloud_replay")) {
                filePath = PathUtils.getExternalAppFilesPath() + url;
            }
            String contentType = "";
            File file = new File(filePath);
            switch (suffix) {
                case "txt": {
                    contentType = "text/plain";
                    break;
                }
                case "html": {
                    contentType = "text/html";
                    break;
                }
                case "js": {
                    contentType = "application/x-javascript";
                    break;
                }
                case "ico": {
                    contentType = "image/x-icon";
                    break;
                }
                case "m3u8": {
                    contentType = "application/vnd.apple.mpegurl";
                    break;
                }
                case "ts": {
                    contentType = "video/mp2t";
                    break;
                }
                case "png": {
                    contentType = "image/png";
                    break;
                }
                default: {
                    contentType = "image/png";
                    LogUtils.d((Object[])new Object[]{"other:" + url});
                }
            }
            FileInputStream targetStream = new FileInputStream(file);
            response = new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, contentType, targetStream, targetStream.available()){

                public void close() throws IOException {
                    super.close();
                }
            };
        }
        catch (Exception ex) {
            LogUtils.d((Object[])new Object[]{ex.getMessage()});
        }
        return response;
    }
}

