package com.edusoho.aiassistant.adpter;

import androidx.annotation.NonNull;

import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.module.BaseLoadMoreModule;
import com.chad.library.adapter.base.module.LoadMoreModule;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.edusoho.aiassistant.R;
import com.edusoho.aiassistant.entity.AIStudyScheduleItem;

public class AIStudyScheduleAdapter extends BaseMultiItemQuickAdapter<AIStudyScheduleItem, BaseViewHolder> implements LoadMoreModule {

    public AIStudyScheduleAdapter() {
        addItemType(AIStudyScheduleItem.DATE, R.layout.item_study_schedule_date);
        addItemType(AIStudyScheduleItem.ITEM, R.layout.item_study_schedule_lesson);

    }

    @Override
    protected void convert(@NonNull BaseViewHolder holder, AIStudyScheduleItem item) {
        if (holder.getItemViewType() == AIStudyScheduleItem.DATE) {
            holder.setText(R.id.tv_date, item.getDate());
        } else {
            holder.setVisible(R.id.bottom, !item.isLast());
            holder.setText(R.id.tv_lesson, item.getTitle());
            holder.setText(R.id.tv_learn_duration, String.format("每日用时 · %s小时", item.getDuration()));
        }
    }

    @NonNull
    @Override
    public BaseLoadMoreModule addLoadMoreModule(@NonNull BaseQuickAdapter<?, ?> baseQuickAdapter) {
        return new BaseLoadMoreModule(this);
    }
}
