package com.edusoho.aiassistant.entity;

import androidx.annotation.NonNull;

import com.blankj.utilcode.util.StringUtils;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import com.edusoho.aiassistant.AIConst;

import java.io.Serializable;
import java.util.UUID;

public class AIMessage implements Serializable, MultiItemEntity {
    public final static int    ASSISTANT_LOADING     = 0;
    public final static int    ASSISTANT_TEXT        = 1;
    public final static int    ASSISTANT_ANSWER_CARD = 2;
    public final static int    ASSISTANT_PUSH_CARD   = 3;
    public final static int    USER                  = 4;
    public final static String ASSISTANT_ROLE        = "assistant";
    public final static String USER_ROLE             = "user";

    private final String clientId = String.valueOf(UUID.randomUUID());
    private       String id;
    private       String threadId;
    private       String chatId;
    private       String userId;
    private       String role;
    /**
     * prologue：开场白，query：用户询问，answer：AI回答，feedback：需要反馈，push：推送通知。
     */
    private       String type;
    private       Object content;
    private       String contentType;
    private       String rating;

    /**
     * 扩展字段，用于 RecyclerView
     **/
    private String event;

    private boolean isFromList; // 标记获取于agent/message/list

    public AIMessage() {
    }

    public AIMessage(String id, String threadId, String chatId, String userId, String role, String content) {
        this.id = id;
        this.threadId = threadId;
        this.chatId = chatId;
        this.userId = userId;
        this.role = role;
        this.content = content;
    }

    public String getClientId() {
        return clientId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getThreadId() {
        return threadId;
    }

    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    public String getChatId() {
        return chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTextContent() {
        return (String) content;
    }

    public CardContent getCardContent() {
        return (CardContent) content;
    }

    public Object getContent() {
        return content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public String getRating() {
        return rating;
    }

    public void setRating(String rating) {
        this.rating = rating;
    }

    /**
     * @return
     */
    public String getEvent() {
        return event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public boolean isFromList() {
        return isFromList;
    }

    public void setFromList(boolean fromList) {
        isFromList = fromList;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    /**
     * 目前支持的5种类型：prologue：开场白，query：用户询问，answer：AI回答，feedback：需要反馈，push：推送通知。
     * 显示在聊天列表中的只有prologue：开场白，query：用户询问，answer：AI回答。
     *
     * @return itemType
     */
    @Override
    public int getItemType() {
        if (StringUtils.equals(event, AIConst.AIMessageStatus.MESSAGE_LOADING)) {
            return ASSISTANT_LOADING;
        } else if (StringUtils.equals(event, AIConst.SSEEventType.CHAT_STARTED)) {
            return ASSISTANT_LOADING;
        } else if (StringUtils.equals(role.toLowerCase(), ASSISTANT_ROLE)) {
            if (StringUtils.equals(contentType, "text")) {
                return ASSISTANT_TEXT;
            } else if (StringUtils.equals(contentType, "card")) {
                if (StringUtils.equals(type, "push")) {
                    return ASSISTANT_PUSH_CARD;
                } else {
//                    type:"answer"
                    return ASSISTANT_ANSWER_CARD;
                }
            }
        } else {
            return USER;
        }
        return -1;
    }

    public void copyFromDeltaMessage(AIMessage message) {
        this.id = message.getId();
        this.chatId = message.getChatId();
        this.threadId = message.getThreadId();
        this.role = message.getRole();
        this.type = message.getType();
        this.event = message.getEvent();
        this.content = this.content + message.getTextContent();
        this.contentType = message.getContentType();
    }

    public void copyFromCompletedMessage(AIMessage message) {
        this.id = message.getId();
        this.chatId = message.getChatId();
        this.threadId = message.getThreadId();
        this.role = message.getRole();
        this.type = message.getType();
        this.event = message.getEvent();
        this.content = message.getContent();
        this.contentType = message.getContentType();
    }

    @NonNull
    @Override
    public String toString() {
        return "Message{" +
                "id='" + id + '\'' +
                ", threadId='" + threadId + '\'' +
                ", chatId='" + chatId + '\'' +
                ", userId='" + userId + '\'' +
                ", role='" + role + '\'' +
                ", type='" + type + '\'' +
                ", content='" + content + '\'' +
                ", contentType='" + contentType + '\'' +
                ", event=" + event +
                '}';
    }
}
