package com.edusoho.aiassistant.entity;

import com.blankj.utilcode.util.GsonUtils;
import com.edusoho.aiassistant.AIConst;

import java.io.Serializable;

import okhttp3.RequestBody;

/**
 * SSE 发送的数据类型
 */
public class AISendMessage implements Serializable {
    private String          role;
    private String          content;
    private String          domainId;
    private boolean         audio;
    private long            audioDuration;
    private MetaData        metadata;
    private WorkflowRequest workflow;

    public AISendMessage(String role, String content, String domainId, MetaData metadata) {
        this.role = role;
        this.content = content;
        this.domainId = domainId;
        this.metadata = metadata;
    }

    public AISendMessage(String role, String content, String domainId, boolean audio, long audioDuration, MetaData metadata) {
        this.role = role;
        this.content = content;
        this.domainId = domainId;
        this.audio = audio;
        this.audioDuration = audioDuration;
        this.metadata = metadata;
    }

    public AISendMessage(String role, String content, String domainId, WorkflowRequest workflow) {
        this.role = role;
        this.content = content;
        this.domainId = domainId;
        this.workflow = workflow;
    }

    public AISendMessage(String role, String content, String domainId, MetaData metadata, WorkflowRequest workflow) {
        this.role = role;
        this.content = content;
        this.domainId = domainId;
        this.metadata = metadata;
        this.workflow = workflow;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public MetaData getMetaData() {
        return metadata;
    }

    public void setMetaData(MetaData metaData) {
        this.metadata = metaData;
    }

    public WorkflowRequest getWorkflow() {
        return workflow;
    }

    public void setWorkflow(WorkflowRequest workflow) {
        this.workflow = workflow;
    }

    public String getDomainId() {
        return domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public RequestBody toRequestBody() {
        String json = GsonUtils.toJson(this);
        return RequestBody.create(json, AIConst.JSON);
    }
}
