package com.edusoho.aiassistant.http;

import com.edusoho.aiassistant.AIConst;
import com.edusoho.aiassistant.AISDKParams;
import com.edusoho.aiassistant.entity.AISendMessage;

import java.util.concurrent.TimeUnit;

import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

public class SSEClient {
    private final OkHttpClient client;
    private       EventSource  eventSource;

    public SSEClient() {
        client = new OkHttpClient.Builder()
                .readTimeout(10, TimeUnit.SECONDS)
                .writeTimeout(10, TimeUnit.SECONDS)
                .connectTimeout(10, TimeUnit.SECONDS)
                .build();
    }

    public void send(AISendMessage aiSendMessage, EventSourceListener l) {
        Request request = new Request.Builder()
                .url(AIConst.AI_SERVER_URL + AIConst.API_CHAT)
                .header("Content-Type", "application/json")
                .header("Accept", "text/event-stream")
                .header("Authorization", "Bearer " + AISDKParams.AI_AGENT_TOKEN)
                .post(aiSendMessage.toRequestBody())
                .build();

        EventSource.Factory factory = EventSources.createFactory(client);
        eventSource = factory.newEventSource(request, l);
    }

    public void cancel() {
        if (eventSource != null) {
            eventSource.cancel();
        }
    }
}
