package com.edusoho.aiassistant.speech;

import android.util.Log;

import com.blankj.utilcode.util.Utils;
import com.bytedance.speech.speechengine.SpeechEngine;
import com.bytedance.speech.speechengine.SpeechEngineDefines;
import com.bytedance.speech.speechengine.SpeechEngineGenerator;

/**
 * 语音转文字工具
 */
public class AsrUtil {
    private static final String               TAG             = "AsrUtil";
    private static       SpeechStreamRecorder mStreamRecorder = null;
    private static       SpeechEngine         mSpeechEngine;

    // 1.聊天页面打开调用
    public static void createSpeechEngine() {
        mSpeechEngine = SpeechEngineGenerator.getInstance();
        mSpeechEngine.createEngine();
        mSpeechEngine.setContext(Utils.getApp());
    }

    // 2.然后初始化
    public static void configInitParams() {
        //【必需配置】Engine Name
        mSpeechEngine.setOptionString(SpeechEngineDefines.PARAMS_KEY_ENGINE_NAME_STRING, SpeechEngineDefines.ASR_ENGINE);
        //【必需配置】配置音频来源
        mSpeechEngine.setOptionString(SpeechEngineDefines.PARAMS_KEY_RECORDER_TYPE_STRING, SpeechEngineDefines.RECORDER_TYPE_RECORDER);

        String address = SensitiveDefines.DEFAULT_ADDRESS;
        Log.i(TAG, "Current address: " + address);
        //【必需配置】识别服务域名
        mSpeechEngine.setOptionString(SpeechEngineDefines.PARAMS_KEY_ASR_ADDRESS_STRING, address);
        String uri = SensitiveDefines.ASR_DEFAULT_URI;
        Log.i(TAG, "Current uri: " + uri);
        //【必需配置】识别服务Uri
        mSpeechEngine.setOptionString(SpeechEngineDefines.PARAMS_KEY_ASR_URI_STRING, uri);

        String appid = SensitiveDefines.APPID;
        //【必需配置】鉴权相关：Appid
        mSpeechEngine.setOptionString(SpeechEngineDefines.PARAMS_KEY_APP_ID_STRING, appid);

        String token = SensitiveDefines.TOKEN;
        //【必需配置】鉴权相关：Token
        mSpeechEngine.setOptionString(SpeechEngineDefines.PARAMS_KEY_APP_TOKEN_STRING, token);
        Log.i(TAG, "token: " + token);
        //【必需配置】识别服务所用集群
        mSpeechEngine.setOptionString(SpeechEngineDefines.PARAMS_KEY_RESOURCE_ID_STRING, "volc.bigasr.sauc.duration");
        mSpeechEngine.setOptionInt(SpeechEngineDefines.PARAMS_KEY_PROTOCOL_TYPE_INT, SpeechEngineDefines.PROTOCOL_TYPE_SEED);
    }

    public static void configOptionalParams() {
        //【可选配置】是否开启顺滑(DDC)
        mSpeechEngine.setOptionBoolean(SpeechEngineDefines.PARAMS_KEY_ASR_ENABLE_DDC_BOOL, false);
        //【可选配置】是否开启文字转数字(ITN)
        mSpeechEngine.setOptionBoolean(SpeechEngineDefines.PARAMS_KEY_ASR_ENABLE_ITN_BOOL, false);
        //【可选配置】是否开启标点(PUNC)
        mSpeechEngine.setOptionBoolean(SpeechEngineDefines.PARAMS_KEY_ASR_SHOW_NLU_PUNC_BOOL, true);
        //【可选配置】设置识别语种
//        mSpeechEngine.setOptionString(SpeechEngineDefines.PARAMS_KEY_ASR_LANGUAGE_STRING, false);
        //【可选配置】是否启用云端自动判停
        mSpeechEngine.setOptionBoolean(SpeechEngineDefines.PARAMS_KEY_ASR_AUTO_STOP_BOOL, false);
        //【可选配置】是否隐藏句尾标点
        mSpeechEngine.setOptionBoolean(SpeechEngineDefines.PARAMS_KEY_ASR_DISABLE_END_PUNC_BOOL, false);

        //【可选配置】控制识别结果返回的形式，全量返回或增量返回，默认为全量
        mSpeechEngine.setOptionString(SpeechEngineDefines.PARAMS_KEY_ASR_RESULT_TYPE_STRING, SpeechEngineDefines.ASR_RESULT_TYPE_FULL);

        //【可选配置】设置VAD头部静音时长，用户多久没说话视为空音频，即静音检测时长
        mSpeechEngine.setOptionInt(SpeechEngineDefines.PARAMS_KEY_ASR_VAD_START_SILENCE_TIME_INT, 0);
        //【可选配置】设置VAD尾部静音时长，用户说话后停顿多久视为说话结束，即自动判停时长
        mSpeechEngine.setOptionInt(SpeechEngineDefines.PARAMS_KEY_ASR_VAD_END_SILENCE_TIME_INT, 0);
        //【可选配置】设置VAD模式，用于定制VAD场景，默认为空
        mSpeechEngine.setOptionString(SpeechEngineDefines.PARAMS_KEY_ASR_VAD_MODE_STRING, "");
        //【可选配置】用户音频输入最大时长，仅一句话识别场景生效，单位毫秒，默认为 60000ms.
        mSpeechEngine.setOptionInt(SpeechEngineDefines.PARAMS_KEY_VAD_MAX_SPEECH_DURATION_INT, 60000);

        //【可选配置】控制是否返回录音音量，在 APP 需要显示音频波形时可以启用
        mSpeechEngine.setOptionBoolean(SpeechEngineDefines.PARAMS_KEY_ENABLE_GET_VOLUME_BOOL, false);
    }

    // 3.初始化
    public static void initEngine(SpeechEngine.SpeechListener listener) {
        int ret = mSpeechEngine.initEngine();
        if (ret != SpeechEngineDefines.ERR_NO_ERROR) {
            String errMessage = "初始化失败，返回值: " + ret;
            Log.e(TAG, errMessage);
            Log.e(TAG, "引擎初始化失败: " + errMessage);
        }
        mSpeechEngine.setListener(listener);
        speechEnginInitSucceeded();
    }

    public static void releaseEngine() {
        if (mSpeechEngine != null) {
            mSpeechEngine.destroyEngine();
            mSpeechEngine = null;
        }
    }

    public static void createStreamRecorder() {
        if (mStreamRecorder == null) {
            mStreamRecorder = new SpeechStreamRecorder();
        }
    }

    public static SpeechStreamRecorder getStreamRecorder() {
        return mStreamRecorder;
    }

    public static SpeechEngine getSpeechEngine() {
        return mSpeechEngine;
    }

    private static void speechEnginInitSucceeded() {
        mStreamRecorder.SetSpeechEngine("ASR", mSpeechEngine);
    }
}
