package com.edusoho.aiassistant.util;

import android.content.Intent;

import com.blankj.utilcode.util.ActivityUtils;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.edusoho.aiassistant.AIAssistantSDK;
import com.edusoho.aiassistant.AIConst;
import com.edusoho.aiassistant.AISDKParams;
import com.edusoho.aiassistant.entity.AIMessage;
import com.edusoho.aiassistant.entity.AISendMessage;
import com.edusoho.aiassistant.entity.MetaData;
import com.edusoho.aiassistant.entity.WorkflowRequest;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AIUtil {

    public static String formatStudyTime1(String startDate, String endDate, List<Integer> weekDays, String everyDayTime) {
        // 定义日期格式
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy年MM月dd日");

        StringBuilder result = new StringBuilder("我将");
        try {
            // 解析日期并格式化
            if (StringUtils.isEmpty(startDate) || StringUtils.equals("从今日开始", endDate)) {
                result.append("从今日开始");
            } else {
                Date start = inputFormat.parse(startDate);
                result.append(outputFormat.format(start)).append("从开始");
            }
            result.append("在每");
            for (int i = 0; i < weekDays.size(); i++) {
                int day = weekDays.get(i);
                result.append(getChineseWeekday(day));
                if (i < weekDays.size() - 1) {
                    result.append("、");
                }
            }
            if (StringUtils.isEmpty(endDate) || StringUtils.equals("学完即止", endDate)) {
                result.append("学习，每次学习").append(everyDayTime).append("小时，").append("直到");
                result.append("学完即止。");
            } else {
                result.append("学习，直到");
                Date end = inputFormat.parse(endDate);
                result.append(outputFormat.format(end)).append("完成学习。");
            }

        } catch (ParseException e) {
            e.printStackTrace();
            return "日期格式错误";
        }

        return result.toString();
    }

    public static String formatStudyTime(String startDate, String endDate, List<Integer> weekDays) {
        // 定义日期格式
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy年MM月dd日");

        StringBuilder result = new StringBuilder("### 学习时间").append("\n");
        try {
            // 解析日期并格式化
            if (StringUtils.isEmpty(startDate) || StringUtils.equals("从今日起", endDate)) {
                result.append("从今日起");
            } else {
                Date start = inputFormat.parse(startDate);
                result.append(outputFormat.format(start));
            }
            result.append("-");

            if (StringUtils.isEmpty(endDate) || StringUtils.equals("学完即止", endDate)) {
                result.append("学完即止");
            } else {
                Date end = inputFormat.parse(endDate);
                result.append(outputFormat.format(end));
            }

            // 添加每周学习日
            result.append("\n").append("### 每周学习日").append("\n");
            if (weekDays == null || weekDays.isEmpty()) {
                result.append("无");
            } else {
                for (int i = 0; i < weekDays.size(); i++) {
                    int day = weekDays.get(i);
                    result.append(getChineseWeekday(day));
                    if (i < weekDays.size() - 1) {
                        result.append("、");
                    }
                }
            }

        } catch (ParseException e) {
            e.printStackTrace();
            return "日期格式错误";
        }

        return result.toString();
    }

    // 将数字星期转换为中文
    private static String getChineseWeekday(int weekday) {
        switch (weekday) {
            case 1:
                return "周一";
            case 2:
                return "周二";
            case 3:
                return "周三";
            case 4:
                return "周四";
            case 5:
                return "周五";
            case 6:
                return "周六";
            case 7:
                return "周日";
            default:
                return "未知";
        }
    }

    // 过滤 contentType == null 的，设置 isFromList = true
    public static void filterContentTypeNull(List<AIMessage> deltaMessageList) {
        Iterator<AIMessage> iterator = deltaMessageList.iterator();
        while (iterator.hasNext()) {
            AIMessage item = iterator.next();
            if (item.getItemType() == -1) {
                iterator.remove();
            } else {
                item.setFromList(true);
            }
        }
    }

    public static void openNews(String url) {
        try {
            Intent intent = new Intent();
            intent.setClassName(AISDKParams.PACKAGE_NAME, AISDKParams.WEB_NEWS_ACTIVITY_NAME);
            intent.putExtra("web_url", url);
            intent.putExtra("title", "资讯");
            ActivityUtils.startActivity(intent);
        } catch (Exception e) {
            ToastUtils.showShort("无法打开相关新闻页面：" + e.getMessage());
        }
    }

    public static void openLesson(String url) {
        try {
            String regex = "^/course/(\\d+)/task/(\\d+)$";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(url);
            if (matcher.matches()) {
                String courseId = matcher.group(1); // 获取第一个捕获组，即 "1272"
                String taskId = matcher.group(2);   // 获取第二个捕获组，即 "6962"
                System.out.println("courseId: " + courseId);
                System.out.println("taskId: " + taskId);
                Intent intent = new Intent();
                intent.setClassName(AISDKParams.PACKAGE_NAME, AISDKParams.LEARN_LESSON_ACTIVITY_NAME);
                intent.putExtra("sdk", AIAssistantSDK.getPackageName());
                if (!StringUtils.isEmpty(courseId)) {
                    intent.putExtra("courseId", Integer.parseInt(courseId));
                }
                if (!StringUtils.isEmpty(taskId)) {
                    intent.putExtra("taskId", Integer.parseInt(taskId));
                }
                ActivityUtils.startActivity(intent);
            } else {
                ToastUtils.showShort("无法获取课时信息");
            }
        } catch (Exception e) {
            ToastUtils.showShort("无法打开相关学习页面：" + e.getMessage());
        }
    }

    public static AISendMessage createTextMessage(String content, String domainId, MetaData metaData) {
        return new AISendMessage(AIMessage.USER_ROLE, content, domainId, metaData);
    }

    public static AISendMessage createAudioTextMessage(String content, String domainId, boolean audio, long audioDuration, MetaData metaData) {
        return new AISendMessage(AIMessage.USER_ROLE, content, domainId, audio, audioDuration, metaData);
    }

    public static AISendMessage createGeneratedPlanMessage(String startDate, String endDate, String dailyLearnDuration, List<Integer> list,
                                                           String content, String domainId, MetaData metaData) {
        WorkflowRequest workflowRequest = new WorkflowRequest();
        workflowRequest.setGeneratedPlanConfig(AIConst.WorkFlowType.PLAN_GENERATE, metaData.getCourseId(), startDate, endDate, dailyLearnDuration, list);
        return new AISendMessage(AIMessage.USER_ROLE, content, domainId, metaData, workflowRequest);
    }

    public static AISendMessage createQuestionAnalysisMessage(String content, String question, String domainId, MetaData metaData) {
        WorkflowRequest workflowRequest = new WorkflowRequest();
        workflowRequest.setQuestionAnalysis(AIConst.WorkFlowType.QUESTION_ANALYSIS, domainId, question);
        return new AISendMessage(AIMessage.USER_ROLE, content, domainId, metaData, workflowRequest);
    }

    public static String convertMessagesToString(List<String> unreadMessages) {
        // 检查空或null的情况
        if (unreadMessages == null || unreadMessages.isEmpty()) {
            return "";
        }

        // 只有一个元素时直接返回
        if (unreadMessages.size() == 1) {
            return unreadMessages.get(0) != null ? unreadMessages.get(0) : "";
        }

        // 多个元素使用逗号连接
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < unreadMessages.size(); i++) {
            String message = unreadMessages.get(i);
            sb.append(message != null ? message : "");
            if (i < unreadMessages.size() - 1) {
                sb.append(",");
            }
        }
        return sb.toString();
    }
}
