package com.edusoho.aiassistant.util;

import android.util.Log;

import com.blankj.utilcode.util.GsonUtils;
import com.blankj.utilcode.util.StringUtils;
import com.edusoho.aiassistant.entity.AISocketMessage;

import org.json.JSONObject;

import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import io.socket.client.IO;
import io.socket.client.Socket;

public class SocketHandler {
    private static final String               TAG        = "SocketHandler";
    private static       Socket               mSocket;
    private static final String               SERVER_URL = "wss://ai-signal.edusoho.net";
    private static final List<SignalListener> listeners  = new CopyOnWriteArrayList<>();

    private SocketHandler() {
    }

    public static void addSignalListener(SignalListener listener) {
        listeners.add(listener);
    }

    public static void removeSignalListener(SignalListener listener) {
        listeners.remove(listener);
    }

    public static synchronized void initSocket(String agentToken) {
        try {
            IO.Options options = IO.Options.builder()
                    .setReconnection(true)
                    .setQuery("token=" + agentToken)
                    .build();
            mSocket = IO.socket(SERVER_URL, options);
            // 监听连接事件
            mSocket.on(Socket.EVENT_CONNECT, args -> Log.d(TAG, "call: Socket.EVENT_CONNECT"));

            mSocket.on(Socket.EVENT_DISCONNECT, args -> Log.d(TAG, "call: Socket.EVENT_DISCONNECT"));

            mSocket.on(Socket.EVENT_CONNECT_ERROR, args -> Log.d(TAG, "call: Socket.EVENT_CONNECT_ERROR"));

            mSocket.on("signal", args -> {
                try {
                    if (StringUtils.equals("signal", args[0].toString())) {
                        Log.d(TAG, "call: " + args[0].toString());
                    } else {
                        JSONObject jsonObject = new JSONObject(args[0].toString());
                        if (!jsonObject.isNull("signal")) {
                            switch (jsonObject.get("signal").toString()) {
                                case "welcome":
                                    Log.d(TAG, "call: " + jsonObject.get("data"));
                                    break;
                                case "message.unread":
                                    AISocketMessage aiSocketMessage = GsonUtils.fromJson(jsonObject.get("data").toString(), AISocketMessage.class);
                                    Log.d(TAG, "call: " + aiSocketMessage);
                                    for (SignalListener listener : listeners) {
                                        listener.onSignalReceived(aiSocketMessage);
                                    }
                                    break;
                            }
                        }
                    }
                    Log.d(TAG, "call: signal");
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

            // 建立连接
            mSocket.connect();


        } catch (URISyntaxException e) {
            Log.e(TAG, "setSocket: " + e.getMessage());
        }
    }

    public static void close() {
        if (mSocket != null) mSocket.close();
    }

    public interface SignalListener {
        void onSignalReceived(AISocketMessage data);
    }
}