package com.edusoho.aiassistant.viewmodel;

import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;

import com.edusoho.aiassistant.entity.AISocketMessage;
import com.edusoho.aiassistant.util.SocketHandler;

public class AIViewModel extends ViewModel implements SocketHandler.SignalListener {
    private final MutableLiveData<AISocketMessage> messageLiveData = new MutableLiveData<>();

    public AIViewModel() {
        SocketHandler.addSignalListener(this);
    }

    @Override
    public void onSignalReceived(AISocketMessage message) {
        messageLiveData.postValue(message);
    }

    @Override
    protected void onCleared() {
        super.onCleared();
        SocketHandler.removeSignalListener(this);
        // 在 ViewModel 被清除时执行清理操作
    }

    public MutableLiveData<AISocketMessage> getMessageLiveData() {
        return messageLiveData;
    }
}
