package com.edusoho.aiassistant.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.LinearLayoutCompat;

import com.edusoho.aiassistant.R;
import com.edusoho.aiassistant.databinding.AiLikePanelBinding;

public class AIRatePanel extends LinearLayoutCompat {
    private AiLikePanelBinding binding;

    public AIRatePanel(@NonNull Context context) {
        super(context);
        init(context, null);
    }

    public AIRatePanel(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public AIRatePanel(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        binding = AiLikePanelBinding.inflate(LayoutInflater.from(context), this);
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AILikePanel);
            try {
                int rate = typedArray.getInt(R.styleable.AILikePanel_rate, 0);
                setRate(rate);
            } finally {
                typedArray.recycle();
            }
        }
    }

    public void setRate(int rate) {
        switch (rate) {
            case 0:
                // 未评价 ("" 或 null)
                binding.ivLike.setImageResource(R.drawable.ai_icon_like_normal);
                binding.ivDislike.setImageResource(R.drawable.ai_icon_dislike_normal);
                break;
            case 1:
                // 好评 (good)
                binding.ivLike.setImageResource(R.drawable.ai_icon_like_pressed);
                binding.ivLike.setEnabled(false);
                binding.ivDislike.setImageResource(R.drawable.ai_icon_dislike_normal);
                binding.ivDislike.setEnabled(true);
                break;
            case 2:
                // 差评 (bad)
                binding.ivLike.setImageResource(R.drawable.ai_icon_like_normal);
                binding.ivLike.setEnabled(true);
                binding.ivDislike.setImageResource(R.drawable.ai_icon_dislike_pressed);
                binding.ivDislike.setEnabled(false);
                break;
        }
    }
}
