/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.util;

import com.edusoho.aiassistant.entity.AIMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AIMessageCache {
    private static final Map<String, List<AIMessage>> mMessageCache = new ConcurrentHashMap<String, List<AIMessage>>();

    public static int size() {
        return mMessageCache.size();
    }

    public static void add(String domainId, List<AIMessage> list) {
        List<AIMessage> messages = mMessageCache.get(domainId);
        if (messages == null) {
            messages = new ArrayList<AIMessage>();
        }
        messages.addAll(list);
        mMessageCache.put(domainId, messages);
    }

    public static void add(String domainId, AIMessage aiMessage) {
        List<AIMessage> messages = mMessageCache.get(domainId);
        if (messages == null) {
            messages = new ArrayList<AIMessage>();
        }
        messages.add(aiMessage);
        mMessageCache.put(domainId, messages);
    }

    public static void push(String domainId, List<AIMessage> list) {
        List<AIMessage> messages = mMessageCache.get(domainId);
        if (messages == null) {
            messages = new ArrayList<AIMessage>();
        }
        messages.addAll(0, list);
        mMessageCache.put(domainId, messages);
    }

    public static void push(String domainId, AIMessage message) {
        List<AIMessage> messages = mMessageCache.get(domainId);
        if (messages == null) {
            messages = new ArrayList<AIMessage>();
        }
        messages.add(0, message);
        mMessageCache.put(domainId, messages);
    }

    public static void remove(String domainId) {
        mMessageCache.remove(domainId);
    }

    public static List<AIMessage> get(String domainId) {
        List<AIMessage> messages = mMessageCache.get(domainId);
        if (messages == null) {
            return Collections.emptyList();
        }
        return messages;
    }
}

