/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.util;

import com.blankj.utilcode.util.StringUtils;
import com.edusoho.aiassistant.entity.AISocketMessage;

public class AIUnreadMessageCache {
    private static AISocketMessage mAISocketMessage = new AISocketMessage();

    public static void replace(AISocketMessage deltaAISocketMessage) {
        mAISocketMessage = deltaAISocketMessage;
    }

    public static int getTotalUnread() {
        return mAISocketMessage.getTotal();
    }

    public static void removeUnread(String domainId) {
        AISocketMessage.SocketMessageData socketMessageData = mAISocketMessage.getMessageDataByDomainId(domainId);
        if (socketMessageData != null) {
            mAISocketMessage.removeRead(domainId);
            mAISocketMessage.setTotal(Math.max(mAISocketMessage.getTotal() - socketMessageData.getCount(), 0));
        }
    }

    public static String getDefaultDomainId() {
        try {
            if (mAISocketMessage.getCounters() != null && !mAISocketMessage.getCounters().isEmpty()) {
                return mAISocketMessage.getCounters().get(mAISocketMessage.getCounters().size() - 1).getDomainId();
            }
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static boolean isAnotherDomainId(String readDomainId) {
        boolean isAnotherDomainIdExists = false;
        for (AISocketMessage.SocketMessageData message : mAISocketMessage.getCounters()) {
            if (StringUtils.equals((CharSequence)readDomainId, (CharSequence)message.getDomainId())) continue;
            isAnotherDomainIdExists = true;
            break;
        }
        return isAnotherDomainIdExists;
    }
}

