/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.widget;

import android.content.Context;
import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import com.blankj.utilcode.util.ActivityUtils;
import com.blankj.utilcode.util.ColorUtils;
import com.blankj.utilcode.util.ConvertUtils;
import com.blankj.utilcode.util.KeyboardUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.bytedance.speech.speechengine.SpeechEngine;
import com.edusoho.aiassistant.R;
import com.edusoho.aiassistant.databinding.AiMessageDialogBoxBinding;
import com.edusoho.aiassistant.http.SSEClient;
import com.edusoho.aiassistant.speech.AsrUtil;
import com.edusoho.aiassistant.speech.SpeechEngineAdapter;
import com.edusoho.aiassistant.widget.AISpeakButton;
import org.json.JSONException;
import org.json.JSONObject;

public class AIMessageDialogBox
extends RelativeLayout
implements SpeechEngine.SpeechListener {
    private static final String TAG = "AIMessageDialogBox";
    private AiMessageDialogBoxBinding binding;
    private AIMessageBoxListener listener;
    private SSEClient mCurSSEClient;
    private long mFinishTalkingTimestamp = -1L;
    private Handler recordHandler = null;
    private Runnable recordRunnable = null;
    private boolean recordIsRunning = false;
    private SpeechEngineAdapter speechEngineAdapter;

    public AIMessageDialogBox(Context context) {
        super(context);
        this.init(context);
    }

    public AIMessageDialogBox(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AIMessageDialogBox(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public void setListener(AIMessageBoxListener listener) {
        this.listener = listener;
    }

    public void setCurrentSSEClient(SSEClient sseClient) {
        this.mCurSSEClient = sseClient;
    }

    public void setSpeechEngineAdapter(SpeechEngineAdapter adapter) {
        this.speechEngineAdapter = adapter;
        this.speechEngineAdapter.setAsrResultListener((text, audioDuration) -> {
            if (this.listener != null) {
                this.listener.sendText(text, true, audioDuration);
            }
        });
    }

    private void init(Context context) {
        this.binding = AiMessageDialogBoxBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        this.binding.etMessageText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                AIMessageDialogBox.this.setTextInputMode();
            }
        });
        this.binding.ivRadio.setOnClickListener(v -> this.setAudioInputMode());
        this.binding.ivKeyboard.setOnClickListener(v -> {
            this.setTextInputMode();
            KeyboardUtils.showSoftInput((View)this);
            this.binding.etMessageText.requestFocus();
        });
        this.binding.ivAudioAnimation.setPadding(0, -120, 0, -120);
        this.binding.tvSpeakButton.setVoiceButtonListener(new AISpeakButton.VoiceButtonListener(){

            @Override
            public void onRecordStart() {
                Log.d((String)"tvSpeakButton", (String)"onRecordStart: ");
                AIMessageDialogBox.this.binding.rlInputBox.setBackgroundResource(R.drawable.bg_input_message_box_record);
                AIMessageDialogBox.this.binding.rlFunctionPanel.setVisibility(8);
                AIMessageDialogBox.this.binding.ivAudioAnimation.setVisibility(0);
                AIMessageDialogBox.this.binding.tvSpeakButton.setVisibility(8);
                AIMessageDialogBox.this.binding.llConvertTextBox.setVisibility(0);
                AIMessageDialogBox.this.binding.ivAudioAnimation.playAnimation();
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)AIMessageDialogBox.this.getLayoutParams();
                layoutParams.height = ConvertUtils.dp2px((float)180.0f);
                AIMessageDialogBox.this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                AIMessageDialogBox.this.setBackgroundColor(ColorUtils.getColor((int)17170443));
                AIMessageDialogBox.this.recordBtnTouchDown();
            }

            @Override
            public void onRecordSlide(boolean isSlided) {
                Log.d((String)"tvSpeakButton", (String)("onRecordSlide: " + isSlided));
                if (isSlided) {
                    AIMessageDialogBox.this.binding.tvPressHint.setText(R.string.press_up);
                    AIMessageDialogBox.this.binding.rlInputBox.setBackgroundResource(R.drawable.bg_input_message_box_slided);
                } else {
                    AIMessageDialogBox.this.binding.tvPressHint.setText(R.string.press_down);
                    AIMessageDialogBox.this.binding.rlInputBox.setBackgroundResource(R.drawable.bg_input_message_box_record);
                }
            }

            @Override
            public void onRecordStop(boolean isRecord) {
                if (isRecord) {
                    Log.d((String)"tvSpeakButton", (String)"onRecordStop: \u53d1\u9001\u5f55\u97f3\u8bb0\u5f55");
                    AIMessageDialogBox.this.speechEngineAdapter.stopRecording(true);
                } else {
                    AIMessageDialogBox.this.speechEngineAdapter.stopRecording(false);
                    Log.d((String)"tvSpeakButton", (String)"onRecordStop: \u4e0d\u53d1\u9001");
                }
                AIMessageDialogBox.this.resetUI();
            }
        });
        this.binding.ivSendText.setOnClickListener(l -> {
            if (this.listener != null) {
                this.listener.sendText(this.binding.etMessageText.getText().toString(), false, 0L);
                this.binding.etMessageText.setText((CharSequence)"");
                KeyboardUtils.hideSoftInput((View)this);
            }
        });
    }

    public void setTextInputMode() {
        if (this.binding.etMessageText.getText() != null && this.binding.etMessageText.getText().toString().isEmpty()) {
            this.binding.ivRadio.setVisibility(0);
            this.binding.ivSendText.setVisibility(8);
        } else {
            this.binding.ivRadio.setVisibility(8);
            this.binding.ivSendText.setVisibility(0);
        }
        this.binding.ivKeyboard.setVisibility(8);
        this.binding.etMessageText.setVisibility(0);
        this.binding.tvSpeakButton.setVisibility(8);
    }

    public void setAudioInputMode() {
        this.binding.ivRadio.setVisibility(8);
        this.binding.ivSendText.setVisibility(8);
        this.binding.ivKeyboard.setVisibility(0);
        this.binding.etMessageText.setVisibility(8);
        this.binding.tvSpeakButton.setVisibility(0);
        KeyboardUtils.hideSoftInput((View)this);
    }

    public void stopAnswer() {
        if (this.mCurSSEClient != null) {
            this.mCurSSEClient.cancel();
        }
    }

    private void resetUI() {
        this.binding.rlInputBox.setBackgroundResource(R.drawable.bg_input_message_box_normal);
        this.binding.rlFunctionPanel.setVisibility(0);
        this.binding.ivAudioAnimation.setVisibility(8);
        this.binding.tvSpeakButton.setVisibility(0);
        this.binding.ivAudioAnimation.cancelAnimation();
        this.binding.llConvertTextBox.setVisibility(8);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        layoutParams.height = ConvertUtils.dp2px((float)80.0f);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.setBackgroundColor(ColorUtils.getColor((int)17170445));
    }

    private void recordBtnTouchDown() {
        this.recordIsRunning = false;
        this.recordHandler = new Handler();
        this.recordRunnable = () -> {
            this.recordIsRunning = true;
            this.speechEngineAdapter.startRecording(this.getContext(), () -> {
                this.recordIsRunning = false;
                ActivityUtils.getTopActivity().runOnUiThread(() -> {
                    ToastUtils.showShort((CharSequence)"\u5f55\u97f3\u542f\u52a8\u5931\u8d25");
                    this.resetUI();
                });
            });
        };
        this.recordHandler.postDelayed(this.recordRunnable, 500L);
    }

    private void recordBtnTouchUp(boolean isSend) {
        if (this.recordIsRunning) {
            this.recordIsRunning = false;
            Log.i((String)TAG, (String)"AsrTouch: Finish");
            this.mFinishTalkingTimestamp = System.currentTimeMillis();
            Log.i((String)TAG, (String)"Directive: DIRECTIVE_FINISH_TALKING");
            AsrUtil.getSpeechEngine().sendDirective(1100, "");
            if (isSend) {
                AsrUtil.getSpeechEngine().sendDirective(1100, "");
            } else {
                AsrUtil.getSpeechEngine().sendDirective(2001, "");
            }
            AsrUtil.getStreamRecorder().Stop();
        } else if (this.recordRunnable != null) {
            Log.i((String)TAG, (String)"AsrTouch: Cancel");
            this.recordHandler.removeCallbacks(this.recordRunnable);
            this.recordRunnable = null;
        }
    }

    public void speechAsrResult(String data, boolean isFinal) {
        long delay = 0L;
        if (isFinal && this.mFinishTalkingTimestamp > 0L) {
            delay = System.currentTimeMillis() - this.mFinishTalkingTimestamp;
            this.mFinishTalkingTimestamp = 0L;
        }
        long response_delay = delay;
        ActivityUtils.getTopActivity().runOnUiThread(() -> {
            try {
                JSONObject reader = new JSONObject(data);
                if (!reader.has("result")) {
                    return;
                }
                String text = reader.getJSONObject("result").getString("text");
                if (text.isEmpty()) {
                    return;
                }
                long audioDuration = reader.getJSONObject("audio_info").getLong("duration");
                if (isFinal && this.listener != null) {
                    this.listener.sendText(text, true, audioDuration);
                }
                this.setResultText(text);
            }
            catch (JSONException e) {
                ToastUtils.showShort((CharSequence)e.getMessage());
            }
        });
    }

    private void setResultText(String text) {
        Log.d((String)TAG, (String)("setResultText: " + text));
    }

    public void onSpeechMessage(int type, byte[] data, int len) {
        String stdData = new String(data);
        switch (type) {
            case 1001: {
                Log.i((String)TAG, (String)("Callback: \u5f15\u64ce\u542f\u52a8\u6210\u529f: data: " + stdData));
                break;
            }
            case 1002: {
                Log.i((String)TAG, (String)("Callback: \u5f15\u64ce\u5173\u95ed: data: " + stdData));
                break;
            }
            case 1003: {
                Log.e((String)TAG, (String)("Callback: \u9519\u8bef\u4fe1\u606f: " + stdData));
                break;
            }
            case 2301: {
                Log.i((String)TAG, (String)("Callback: \u5efa\u8fde\u6210\u529f: data: " + stdData));
                break;
            }
            case 1201: {
                Log.d((String)TAG, (String)"Callback: ASR \u5f53\u524d\u8bf7\u6c42\u7684\u90e8\u5206\u7ed3\u679c");
                break;
            }
            case 1204: {
                Log.i((String)TAG, (String)"Callback: ASR \u5f53\u524d\u8bf7\u6c42\u6700\u7ec8\u7ed3\u679c");
                this.speechAsrResult(stdData, true);
                break;
            }
            case 1600: {
                Log.d((String)TAG, (String)"Callback: \u5f55\u97f3\u97f3\u91cf");
                break;
            }
        }
    }

    public static interface AIMessageBoxListener {
        public void sendText(String var1, boolean var2, long var3);
    }
}

