package com.edusoho.aiassistant;

import com.edusoho.aiassistant.entity.MetaData;

import java.io.Serializable;

public class AIAssistantConfig implements Serializable {
    private final String   preMessageType;
    private final String   preSendMessage;
    private final MetaData metaData;
    private final String   domainId;
    private final boolean  isShowAccessible; // 是否显示快捷按钮模块
    private final boolean  isGeneratedStudyPlan; // 是否制定过计划。是：制定学习计划；否：重新制定学习计划，查看学习计划
    private final String   question;

    // 私有构造方法，只能通过Builder创建
    private AIAssistantConfig(Builder builder) {
        this.preMessageType = builder.preMessageType;
        this.preSendMessage = builder.preSendMessage;
        this.metaData = builder.metaData;
        this.domainId = builder.domainId;
        this.isShowAccessible = builder.isShowAccessible;
        this.question = builder.question;  // 初始化新增字段
        this.isGeneratedStudyPlan = builder.isGeneratedStudyPlan;
    }

    // Getter方法
    public String getPreMessageType() {
        return preMessageType;
    }

    public String getPreSendMessage() {
        return preSendMessage;
    }

    public MetaData getMetaData() {
        return metaData;
    }

    public String getDomainId() {
        return domainId;
    }

    public boolean isShowAccessible() {
        return isShowAccessible;
    }

    public boolean isGeneratedStudyPlan() {
        return isGeneratedStudyPlan;
    }

    public String getQuestion() {  // 新增的getter
        return question;
    }

    // 静态Builder类
    public static class Builder {
        private String   preMessageType;
        private String   preSendMessage;
        private MetaData metaData;
        private String   domainId;
        private boolean  isShowAccessible;
        private boolean  isGeneratedStudyPlan;
        private String   question;

        // 默认构造函数
        public Builder() {
        }

        // 设置各个参数的方法，返回Builder自身以支持链式调用
        public Builder preMessageType(String preMessageType) {
            this.preMessageType = preMessageType;
            return this;
        }

        public Builder preSendMessage(String preSendMessage) {
            this.preSendMessage = preSendMessage;
            return this;
        }

        public Builder metaData(MetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder isShowAccessible(boolean isShowAccessible) {
            this.isShowAccessible = isShowAccessible;
            return this;
        }

        public Builder question(String question) {
            this.question = question;
            return this;
        }

        public Builder isGeneratedStudyPlan(boolean isGeneratedStudyPlan) {
            this.isGeneratedStudyPlan = isGeneratedStudyPlan;
            return this;
        }


        // 构建最终的AIAssistantConfig对象
        public AIAssistantConfig build() {
            return new AIAssistantConfig(this);
        }
    }

    // 示例用法
//    public static void main(String[] args) {
//        AIAssistantConfig config = new AIAssistantConfig.Builder()
//                .preMessageType("INFO")
//                .preSendMessage("Hello World")
//                .messageCount(5)
//                .metaData(new MetaData())  // 假设MetaData是一个已定义的类
//                .domainId("domain123")
//                .isShowAccessible(true)
//                .question("How can I help you today?")  // 使用新增的字段
//                .build();
//    }
}
