package com.edusoho.aiassistant.http;

import com.edusoho.aiassistant.AIConst;
import com.edusoho.aiassistant.entity.AIMessage;
import com.edusoho.aiassistant.util.MessageDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.util.concurrent.TimeUnit;

import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class HttpClient {
    private static volatile Retrofit     retrofit;
    private static          OkHttpClient okHttpClient;

    public static Retrofit getInstance() {
        if (retrofit == null) {
            synchronized (HttpClient.class) {
                if (retrofit == null) {
                    Gson gson = new GsonBuilder()
                            .registerTypeAdapter(AIMessage.class, new MessageDeserializer())
                            .create();
                    retrofit = new Retrofit.Builder()
                            .baseUrl(AIConst.AI_SERVER_URL)
                            .addConverterFactory(GsonConverterFactory.create(gson))
                            .addCallAdapterFactory(RxJavaCallAdapterFactory.create())
                            .client(getOkHttpClient())
                            .build();
                }
            }
        }
        return retrofit;
    }

    public static OkHttpClient getOkHttpClient() {
        if (okHttpClient == null) {
            okHttpClient = new OkHttpClient.Builder()
                    .addInterceptor(new RequestInterceptor())
                    .readTimeout(30, TimeUnit.SECONDS)
                    .writeTimeout(30, TimeUnit.SECONDS)
                    .connectTimeout(10, TimeUnit.SECONDS)
                    .build();
        }
        return okHttpClient;
    }
}