package com.edusoho.aiassistant.speech;


import android.Manifest;
import android.content.Context;
import android.util.Log;

import androidx.annotation.NonNull;

import com.blankj.utilcode.util.PermissionUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.bytedance.speech.speechengine.SpeechEngine;
import com.bytedance.speech.speechengine.SpeechEngineDefines;

import java.util.List;

public class BytedanceSpeechEngineAdapter implements SpeechEngineAdapter {
    private static final String TAG = "BytedanceSpeechEngineAdapter";

    @Override
    public void startRecording(Context context, Runnable onError) {
        Log.i(TAG, "配置启动参数.");
        AsrUtil.configOptionalParams();
        // 关闭云端自动判停功能
        AsrUtil.getSpeechEngine().setOptionBoolean(SpeechEngineDefines.PARAMS_KEY_ASR_AUTO_STOP_BOOL, false);

        // 停止之前的引擎
        Log.i(TAG, "关闭引擎（同步）");
        Log.i(TAG, "Directive: DIRECTIVE_SYNC_STOP_ENGINE");
        int ret = AsrUtil.getSpeechEngine().sendDirective(SpeechEngineDefines.DIRECTIVE_SYNC_STOP_ENGINE, "");
        if (ret != SpeechEngineDefines.ERR_NO_ERROR) {
            Log.e(TAG, "send directive syncstop failed, " + ret);
            if (onError != null) {
                onError.run();
            }
            return;
        }

        // 启动引擎
        Log.i(TAG, "启动引擎");
        Log.i(TAG, "Directive: DIRECTIVE_START_ENGINE");
        ret = AsrUtil.getSpeechEngine().sendDirective(SpeechEngineDefines.DIRECTIVE_START_ENGINE, "");
        if (ret == SpeechEngineDefines.ERR_REC_CHECK_ENVIRONMENT_FAILED) {
            PermissionUtils.permission(Manifest.permission.RECORD_AUDIO)
                    .callback(new PermissionUtils.FullCallback() {
                        @Override
                        public void onGranted(@NonNull List<String> granted) {
                            // 权限授予后可重新尝试启动
                        }

                        @Override
                        public void onDenied(@NonNull List<String> deniedForever, @NonNull List<String> denied) {
                            ToastUtils.showShort("录音权限被拒绝");
                            if (onError != null) {
                                onError.run();
                            }
                        }
                    }).request();
        } else if (ret != SpeechEngineDefines.ERR_NO_ERROR) {
            Log.e(TAG, "send directive start failed, " + ret);
            if (onError != null) {
                onError.run();
            }
        }
    }

    @Override
    public void stopRecording(boolean isSend) {
        Log.i(TAG, "AsrTouch: Finish");
        // 结束用户音频输入
        Log.i(TAG, "Directive: DIRECTIVE_FINISH_TALKING");
        AsrUtil.getSpeechEngine().sendDirective(SpeechEngineDefines.DIRECTIVE_FINISH_TALKING, "");
        if (isSend) {
            AsrUtil.getSpeechEngine().sendDirective(SpeechEngineDefines.DIRECTIVE_FINISH_TALKING, "");
        } else {
            AsrUtil.getSpeechEngine().sendDirective(SpeechEngineDefines.DIRECTIVE_SYNC_STOP_ENGINE, "");
        }
        AsrUtil.getStreamRecorder().Stop();
    }

    @Override
    public SpeechEngine getSpeechEngine() {
        return AsrUtil.getSpeechEngine();
    }

    @Override
    public void setAsrResultListener(AsrResultListener listener) {

    }
}
