package com.edusoho.aiassistant.speech;

import android.content.Context;

import com.bytedance.speech.speechengine.SpeechEngine;

public interface SpeechEngineAdapter {

    /**
     * 开始录音
     *
     * @param context 上下文
     * @param onError 错误回调
     */
    void startRecording(Context context, Runnable onError);

    /**
     * 停止录音
     *
     * @param isSend 是否发送录音结果
     */
    void stopRecording(boolean isSend);

    /**
     * 获取当前语音引擎
     *
     * @return 语音引擎实例
     */
    SpeechEngine getSpeechEngine();

    /**
     * 设置语音识别结果回调
     *
     * @param listener 结果监听器
     */
    void setAsrResultListener(AsrResultListener listener);

    /**
     * 语音识别结果监听器
     */
    interface AsrResultListener {
        void onAsrResult(String text, long audioDuration);
    }
}
