package com.edusoho.aiassistant.util;

import android.content.Context;
import android.os.Build;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LineHeightSpan;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.blankj.utilcode.util.ColorUtils;
import com.blankj.utilcode.util.ConvertUtils;
import com.edusoho.aiassistant.R;
import com.edusoho.aiassistant.widget.BottomMarginSpan;

import org.commonmark.node.Heading;

import java.util.Collection;
import java.util.Collections;

import io.noties.markwon.AbstractMarkwonPlugin;
import io.noties.markwon.Markwon;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.MarkwonSpansFactory;
import io.noties.markwon.MarkwonVisitor;
import io.noties.markwon.RenderProps;
import io.noties.markwon.SpanFactory;
import io.noties.markwon.core.CoreProps;
import io.noties.markwon.core.MarkwonTheme;
import io.noties.markwon.ext.latex.JLatexMathPlugin;
import io.noties.markwon.ext.latex.LatexParseStyle;
import io.noties.markwon.ext.tables.TableAwareMovementMethod;
import io.noties.markwon.ext.tables.TablePlugin;
import io.noties.markwon.html.HtmlPlugin;
import io.noties.markwon.html.HtmlTag;
import io.noties.markwon.html.MarkwonHtmlRenderer;
import io.noties.markwon.html.TagHandler;
import io.noties.markwon.image.ImagesPlugin;
import io.noties.markwon.inlineparser.MarkwonInlineParserPlugin;
import io.noties.markwon.movement.MovementMethodPlugin;

public class MarkwonUtil {

    public static Markwon createNormalStyle(Context context, TextView textView) {
        return Markwon.builder(context)
                .usePlugin(MovementMethodPlugin.create(TableAwareMovementMethod.create()))
                .usePlugin(TablePlugin.create(context))
                .usePlugin(ImagesPlugin.create(true))
                .usePlugin(HtmlPlugin.create())
                .usePlugin(MarkwonInlineParserPlugin.create())
                .usePlugin(JLatexMathPlugin.create(
                        textView.getTextSize(), new JLatexMathPlugin.BuilderConfigure() {
                            @Override
                            public void configureBuilder(@NonNull JLatexMathPlugin.Builder builder) {
                                builder.inlinesEnabled(true)
                                        .blockStyle(LatexParseStyle.STYLE_DOLLAR)
                                        .inlineStyle(LatexParseStyle.STYLE_DOLLAR);
                            }
                        }
                ))
                .build();
    }

    public static Markwon createStudyPlanStyle(Context context) {
        return Markwon.builder(context)
                .usePlugin(TablePlugin.create(context))
                .usePlugin(HtmlPlugin.create(plugin -> plugin.addHandler(new TagHandler() {
                    @Override
                    public void handle(@NonNull MarkwonVisitor visitor, @NonNull MarkwonHtmlRenderer renderer, @NonNull HtmlTag tag) {
                        visitor.builder().setSpan(new ForegroundColorSpan(ColorUtils.getColor(R.color.color_87898F)), tag.start(), tag.end());
                        visitor.builder().setSpan(new AbsoluteSizeSpan(ConvertUtils.dp2px(13)), tag.start(), tag.end());
                    }

                    @NonNull
                    @Override
                    public Collection<String> supportedTags() {
                        return Collections.singleton("span");
                    }
                })))
                .usePlugin(new AbstractMarkwonPlugin() {

                    @Override
                    public void configureSpansFactory(@NonNull MarkwonSpansFactory.Builder builder) {
                        builder.appendFactory(Heading.class, new SpanFactory() {

                            @Nullable
                            @Override
                            public Object getSpans(@NonNull MarkwonConfiguration configuration, @NonNull RenderProps props) {
                                Integer level = CoreProps.HEADING_LEVEL.get(props);
                                if (level == 3) {
                                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
                                        return new Object[]{new AbsoluteSizeSpan(ConvertUtils.dp2px(14)),
                                                new LineHeightSpan.Standard(12),
                                                new BottomMarginSpan(-20),
                                                new ForegroundColorSpan(ColorUtils.getColor(R.color.color_37393D))};
                                    }
                                }
                                return null;
                            }
                        });
                    }

                    @Override
                    public void configureTheme(@NonNull MarkwonTheme.Builder builder) {
                        builder.bulletWidth(14);
                        builder.isLinkUnderlined(false);
                        builder.linkColor(ColorUtils.getColor(R.color.color_165DFF));
                    }

                    @Override
                    public void configureConfiguration(@NonNull MarkwonConfiguration.Builder builder) {
                        builder.linkResolver((view, s) -> AIUtil.openLesson(s));
                    }
                })
                .usePlugin(MovementMethodPlugin.create(TableAwareMovementMethod.create()))
                .build();
    }

    public static Markwon createUserStudyTimeStyle(Context context) {
        return Markwon.builder(context)
                .usePlugin(new AbstractMarkwonPlugin() {
                    @Override
                    public void configureSpansFactory(@NonNull MarkwonSpansFactory.Builder builder) {
                        builder.appendFactory(Heading.class, new SpanFactory() {

                            @Nullable
                            @Override
                            public Object getSpans(@NonNull MarkwonConfiguration configuration, @NonNull RenderProps props) {
                                Integer level = CoreProps.HEADING_LEVEL.get(props);
                                if (level == 3) {
                                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
                                        return new Object[]{new AbsoluteSizeSpan(ConvertUtils.dp2px(16)),
                                                new LineHeightSpan.Standard(10),
                                                new BottomMarginSpan(-38)};
                                    }
                                }
                                return null;
                            }
                        });
                    }
                })
                .build();
    }
}
