package com.edusoho.aiassistant.util;

import com.edusoho.aiassistant.entity.AIMessage;
import com.edusoho.aiassistant.entity.CardContent;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;

import java.lang.reflect.Type;

public class MessageDeserializer implements JsonDeserializer<AIMessage> {


    @Override
    public AIMessage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        AIMessage message = new AIMessage();

        message.setId(jsonObject.get("id").getAsString());
        message.setThreadId(jsonObject.get("threadId").getAsString());
//        message.setChatId(jsonObject.get("chatId").getAsString());
        message.setChatId(jsonObject.has("chatId") && !jsonObject.get("chatId").isJsonNull() ? jsonObject.get("chatId").getAsString() : null);
        message.setUserId(jsonObject.has("userId") && !jsonObject.get("userId").isJsonNull() ? jsonObject.get("userId").getAsString() : null);
        message.setRole(jsonObject.get("role").getAsString());
        message.setType(jsonObject.get("type").getAsString());
        message.setContentType(jsonObject.has("contentType") && !jsonObject.get("contentType").isJsonNull() ?
                jsonObject.get("contentType").getAsString() : null);
        message.setRating(jsonObject.has("rating") && !jsonObject.get("rating").isJsonNull() ?
                jsonObject.get("rating").getAsString() : null);

        String contentType = message.getContentType();
        if (jsonObject.has("content")) {
            JsonElement contentElement = jsonObject.get("content");
            if ("text".equals(contentType)) {
                message.setContent(contentElement.getAsString());
            } else if ("card".equals(contentType)) {
                // content 是字符串形式的 JSON，解析为 CardContent
                String contentStr = contentElement.getAsString();
                CardContent cardContent = context.deserialize(new JsonParser().parse(contentStr), CardContent.class);
                message.setContent(cardContent);
            }
        } else {
            message.setContent(null);
        }
        return message;
    }
}
