package com.edusoho.aiassistant.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.widget.LinearLayout;

import androidx.annotation.Nullable;

import com.edusoho.aiassistant.R;
import com.edusoho.aiassistant.databinding.AiAccessibleButtonBinding;

public class AIAccessibleButton extends LinearLayout {
    private AiAccessibleButtonBinding binding;

    public AIAccessibleButton(Context context) {
        super(context);
        init(context, null);
    }

    public AIAccessibleButton(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public AIAccessibleButton(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    public AIAccessibleButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        binding = AiAccessibleButtonBinding.inflate(LayoutInflater.from(context), this);
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AIAccessibleButton);
            try {
                int iconResId = typedArray.getResourceId(R.styleable.AIAccessibleButton_icon, R.drawable.ai_icon_generate_study_plan);
                binding.ivIcon.setImageResource(iconResId);
                String text = typedArray.getString(R.styleable.AIAccessibleButton_text);
                binding.tvAccessibleText.setText(text);
            } finally {
                typedArray.recycle();
            }
        }
    }

    public String getText() {
        return binding.tvAccessibleText.getText().toString();
    }
}
