package com.edusoho.aiassistant.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;

import com.blankj.utilcode.util.ColorUtils;
import com.edusoho.aiassistant.R;

public class AIWeekDayWidget extends AppCompatTextView {

    public AIWeekDayWidget(@NonNull Context context) {
        super(context);
        init(context, null);
    }

    public AIWeekDayWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public AIWeekDayWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AIWeekDayWidget);
            try {
                boolean isSelected = typedArray.getBoolean(R.styleable.AIWeekDayWidget_user_selected, false);
                setSelected(isSelected);
            } finally {
                typedArray.recycle();
            }
        }
    }

    public void toggleState() {
        if (isSelected()) {
            setSelected(false);
            setTextColor(ColorUtils.getColor(R.color.color_37393D));
        } else {
            setSelected(true);
            setTextColor(ColorUtils.getColor(R.color.color_165DFF));
        }
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (selected) {
            setTextColor(ColorUtils.getColor(R.color.color_165DFF));
        } else {
            setTextColor(ColorUtils.getColor(R.color.color_37393D));
        }
    }

    // 可选：提供方法给外部控制状态
//    public void setSelectedState(boolean selected) {
//        if (isSelected != selected) {
//            toggleState();
//        }
//    }

//    public boolean isSelected() {
//        return isSelected;
//    }
}
