package com.edusoho.aiassistant.widget;

import android.content.Context;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.util.AttributeSet;

import androidx.appcompat.widget.AppCompatTextView;

public class GradientTextView extends AppCompatTextView {
    private int[]           colors;  // 渐变色数组
    private Shader.TileMode tileMode = Shader.TileMode.CLAMP;  // 渐变模式

    public GradientTextView(Context context) {
        super(context);
        init();
    }

    public GradientTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public GradientTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    private void init() {
        // 默认颜色（可动态修改）
        colors = new int[]{
                0xFF9832FF,
                0xFF323CFF,
                0xff32ADFF
        };
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            // 计算渐变方向坐标
            double radians = Math.toRadians(315);
            float width = getWidth();
            float height = getHeight();

            // 计算对角线长度（确保渐变覆盖整个 TextView）
            float length = (float) Math.sqrt(width * width + height * height);

            // 计算起点和终点的坐标偏移量
            float startX = (float) (-length * Math.cos(radians) / 2 + width / 2);
            float startY = (float) (length * Math.sin(radians) / 2 + height / 2);
            float endX = (float) (length * Math.cos(radians) / 2 + width / 2);
            float endY = (float) (-length * Math.sin(radians) / 2 + height / 2);

            // 创建 LinearGradient
            LinearGradient gradient = new LinearGradient(
                    startX, startY, endX, endY,
                    colors, null, tileMode
            );
            getPaint().setShader(gradient);
        }
    }
}
