/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.entity;

import androidx.annotation.NonNull;
import com.blankj.utilcode.util.StringUtils;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import com.edusoho.aiassistant.entity.CardContent;
import java.io.Serializable;
import java.util.UUID;

public class AIMessage
implements Serializable,
MultiItemEntity {
    public static final int ASSISTANT_LOADING = 0;
    public static final int ASSISTANT_TEXT = 1;
    public static final int ASSISTANT_ANSWER_CARD = 2;
    public static final int ASSISTANT_PUSH_CARD = 3;
    public static final int USER = 4;
    public static final String ASSISTANT_ROLE = "assistant";
    public static final String USER_ROLE = "user";
    private final String clientId = String.valueOf(UUID.randomUUID());
    private String id;
    private String threadId;
    private String chatId;
    private String userId;
    private String role;
    private String type;
    private Object content;
    private String contentType;
    private String rating;
    private String event;
    private boolean isFromList;

    public AIMessage() {
    }

    public AIMessage(String id2, String threadId, String chatId, String userId, String role, String content) {
        this.id = id2;
        this.threadId = threadId;
        this.chatId = chatId;
        this.userId = userId;
        this.role = role;
        this.content = content;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id2) {
        this.id = id2;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTextContent() {
        return (String)this.content;
    }

    public CardContent getCardContent() {
        return (CardContent)this.content;
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public String getRating() {
        return this.rating;
    }

    public void setRating(String rating) {
        this.rating = rating;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public boolean isFromList() {
        return this.isFromList;
    }

    public void setFromList(boolean fromList) {
        this.isFromList = fromList;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int getItemType() {
        if (StringUtils.equals((CharSequence)this.event, (CharSequence)"message.loading")) {
            return 0;
        }
        if (StringUtils.equals((CharSequence)this.event, (CharSequence)"chat.started")) {
            return 0;
        }
        if (StringUtils.equals((CharSequence)this.role.toLowerCase(), (CharSequence)ASSISTANT_ROLE)) {
            if (StringUtils.equals((CharSequence)this.contentType, (CharSequence)"text")) {
                return 1;
            }
            if (StringUtils.equals((CharSequence)this.contentType, (CharSequence)"card")) {
                if (StringUtils.equals((CharSequence)this.type, (CharSequence)"push")) {
                    return 3;
                }
                return 2;
            }
        } else {
            return 4;
        }
        return -1;
    }

    public void copyFromDeltaMessage(AIMessage message) {
        this.id = message.getId();
        this.chatId = message.getChatId();
        this.threadId = message.getThreadId();
        this.role = message.getRole();
        this.type = message.getType();
        this.event = message.getEvent();
        this.content = this.content + message.getTextContent();
        this.contentType = message.getContentType();
    }

    public void copyFromCompletedMessage(AIMessage message) {
        this.id = message.getId();
        this.chatId = message.getChatId();
        this.threadId = message.getThreadId();
        this.role = message.getRole();
        this.type = message.getType();
        this.event = message.getEvent();
        this.content = message.getContent();
        this.contentType = message.getContentType();
    }

    @NonNull
    public String toString() {
        return "Message{id='" + this.id + '\'' + ", threadId='" + this.threadId + '\'' + ", chatId='" + this.chatId + '\'' + ", userId='" + this.userId + '\'' + ", role='" + this.role + '\'' + ", type='" + this.type + '\'' + ", content='" + this.content + '\'' + ", contentType='" + this.contentType + '\'' + ", event=" + this.event + '}';
    }
}

