/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.speech;

import android.media.AudioRecord;
import android.util.Log;
import com.bytedance.speech.speechengine.SpeechEngine;
import java.io.ByteArrayOutputStream;

public class SpeechStreamRecorder {
    private static final String TAG = "SpeechStreamRecorder";
    private static final int SAMPLE_RATE = 44100;
    private static final int CHANNEL_NUM = 2;
    private static final int BYTES_PER_SAMPLE = 2;
    private static final float BUFFER_SIZE_IN_SECONDS = 0.08f;
    private static final int DEFAULT_PACKAGE_DURATION = 100;
    private AudioRecord mRecorder;
    private Thread mWorker = null;
    private int mBufferSize = 0;
    private int mPackageDuration = 100;
    private String mViewId = "";
    private SpeechEngine mSpeechEngine = null;

    public int GetStreamSampleRate() {
        return 44100;
    }

    public int GetStreamChannel() {
        return 2;
    }

    public void SetSpeechEngine(String viewId, SpeechEngine speechEngine) {
        this.mViewId = viewId;
        this.mSpeechEngine = speechEngine;
    }

    public boolean Start() {
        if (!this.InitStreamRecorder()) {
            return false;
        }
        if (null != this.mWorker) {
            if (this.mWorker.isAlive()) {
                Log.w((String)TAG, (String)"Already start!");
                return true;
            }
            this.mWorker = null;
        }
        this.mPackageDuration = 100;
        this.mWorker = new RecorderThread();
        this.mWorker.start();
        Log.i((String)TAG, (String)"Stream Recorder Started.");
        return true;
    }

    public void Stop() {
        if (null == this.mWorker) {
            Log.w((String)TAG, (String)"Not start yet!");
            return;
        }
        this.mWorker.interrupt();
        try {
            this.mWorker.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        this.mWorker = null;
        Log.i((String)TAG, (String)"Stream Recorder Stopped.");
    }

    private boolean InitStreamRecorder() {
        if (this.mRecorder != null) {
            return true;
        }
        this.mBufferSize = Math.round(14112.0f);
        int minBufferSize = AudioRecord.getMinBufferSize((int)44100, (int)12, (int)2);
        minBufferSize = Math.max(minBufferSize, this.mBufferSize);
        this.mRecorder = new AudioRecord(1, 44100, 12, 2, minBufferSize * 10);
        if (this.mRecorder.getState() == 0) {
            Log.e((String)TAG, (String)"Failed to initialize stream recorder.");
            this.mRecorder.release();
            this.mRecorder = null;
            return false;
        }
        return true;
    }

    private final class RecorderThread
    extends Thread {
        private RecorderThread() {
        }

        @Override
        public void run() {
            if (SpeechStreamRecorder.this.mRecorder == null) {
                return;
            }
            SpeechStreamRecorder.this.mRecorder.startRecording();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int nread = 0;
            long totalPackageSize = 176400L * (long)SpeechStreamRecorder.this.mPackageDuration / 1000L;
            while (!this.isInterrupted() && nread >= 0) {
                int ret;
                byte[] buffer = new byte[SpeechStreamRecorder.this.mBufferSize];
                bos.reset();
                long curPackageSize = 0L;
                while (!this.isInterrupted() && nread >= 0 && curPackageSize < totalPackageSize) {
                    nread = SpeechStreamRecorder.this.mRecorder.read(buffer, 0, SpeechStreamRecorder.this.mBufferSize);
                    if (nread > 0) {
                        Log.i((String)SpeechStreamRecorder.TAG, (String)("Current package size: " + curPackageSize + ", total package size: " + totalPackageSize));
                        curPackageSize += (long)nread;
                        bos.write(buffer, 0, nread);
                        continue;
                    }
                    if (nread >= 0) continue;
                    Log.e((String)SpeechStreamRecorder.TAG, (String)"Recorder error.");
                }
                if (this.isInterrupted() || (ret = SpeechStreamRecorder.this.mSpeechEngine.feedAudio(buffer = bos.toByteArray(), buffer.length)) == 0) continue;
                Log.e((String)SpeechStreamRecorder.TAG, (String)"Feed audio failed.");
                break;
            }
            SpeechStreamRecorder.this.mRecorder.stop();
        }
    }
}

