/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.util;

import android.content.Intent;
import com.blankj.utilcode.util.ActivityUtils;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.edusoho.aiassistant.AIAssistantSDK;
import com.edusoho.aiassistant.AISDKParams;
import com.edusoho.aiassistant.entity.AIMessage;
import com.edusoho.aiassistant.entity.AISendMessage;
import com.edusoho.aiassistant.entity.MetaData;
import com.edusoho.aiassistant.entity.WorkflowRequest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AIUtil {
    public static String formatStudyTime1(String startDate, String endDate, List<Integer> weekDays, String everyDayTime) {
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        StringBuilder result = new StringBuilder("\u6211\u5c06");
        try {
            if (StringUtils.isEmpty((CharSequence)startDate) || StringUtils.equals((CharSequence)"\u4ece\u4eca\u65e5\u5f00\u59cb", (CharSequence)endDate)) {
                result.append("\u4ece\u4eca\u65e5\u5f00\u59cb");
            } else {
                Date start = inputFormat.parse(startDate);
                result.append(outputFormat.format(start)).append("\u4ece\u5f00\u59cb");
            }
            result.append("\u5728\u6bcf");
            for (int i = 0; i < weekDays.size(); ++i) {
                int day = weekDays.get(i);
                result.append(AIUtil.getChineseWeekday(day));
                if (i >= weekDays.size() - 1) continue;
                result.append("\u3001");
            }
            if (StringUtils.isEmpty((CharSequence)endDate) || StringUtils.equals((CharSequence)"\u5b66\u5b8c\u5373\u6b62", (CharSequence)endDate)) {
                result.append("\u5b66\u4e60\uff0c\u6bcf\u6b21\u5b66\u4e60").append(everyDayTime).append("\u5c0f\u65f6\uff0c").append("\u76f4\u5230");
                result.append("\u5b66\u5b8c\u5373\u6b62\u3002");
            } else {
                result.append("\u5b66\u4e60\uff0c\u76f4\u5230");
                Date end = inputFormat.parse(endDate);
                result.append(outputFormat.format(end)).append("\u5b8c\u6210\u5b66\u4e60\u3002");
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "\u65e5\u671f\u683c\u5f0f\u9519\u8bef";
        }
        return result.toString();
    }

    public static String formatStudyTime(String startDate, String endDate, List<Integer> weekDays) {
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        StringBuilder result = new StringBuilder("### \u5b66\u4e60\u65f6\u95f4").append("\n");
        try {
            if (StringUtils.isEmpty((CharSequence)startDate) || StringUtils.equals((CharSequence)"\u4ece\u4eca\u65e5\u8d77", (CharSequence)endDate)) {
                result.append("\u4ece\u4eca\u65e5\u8d77");
            } else {
                Date start = inputFormat.parse(startDate);
                result.append(outputFormat.format(start));
            }
            result.append("-");
            if (StringUtils.isEmpty((CharSequence)endDate) || StringUtils.equals((CharSequence)"\u5b66\u5b8c\u5373\u6b62", (CharSequence)endDate)) {
                result.append("\u5b66\u5b8c\u5373\u6b62");
            } else {
                Date end = inputFormat.parse(endDate);
                result.append(outputFormat.format(end));
            }
            result.append("\n").append("### \u6bcf\u5468\u5b66\u4e60\u65e5").append("\n");
            if (weekDays == null || weekDays.isEmpty()) {
                result.append("\u65e0");
            } else {
                for (int i = 0; i < weekDays.size(); ++i) {
                    int day = weekDays.get(i);
                    result.append(AIUtil.getChineseWeekday(day));
                    if (i >= weekDays.size() - 1) continue;
                    result.append("\u3001");
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "\u65e5\u671f\u683c\u5f0f\u9519\u8bef";
        }
        return result.toString();
    }

    private static String getChineseWeekday(int weekday) {
        switch (weekday) {
            case 1: {
                return "\u5468\u4e00";
            }
            case 2: {
                return "\u5468\u4e8c";
            }
            case 3: {
                return "\u5468\u4e09";
            }
            case 4: {
                return "\u5468\u56db";
            }
            case 5: {
                return "\u5468\u4e94";
            }
            case 6: {
                return "\u5468\u516d";
            }
            case 7: {
                return "\u5468\u65e5";
            }
        }
        return "\u672a\u77e5";
    }

    public static void filterContentTypeNull(List<AIMessage> deltaMessageList) {
        Iterator<AIMessage> iterator = deltaMessageList.iterator();
        while (iterator.hasNext()) {
            AIMessage item = iterator.next();
            if (item.getItemType() == -1) {
                iterator.remove();
                continue;
            }
            item.setFromList(true);
        }
    }

    public static void openNews(String url) {
        try {
            Intent intent = new Intent();
            intent.setClassName(AISDKParams.PACKAGE_NAME, AISDKParams.WEB_NEWS_ACTIVITY_NAME);
            intent.putExtra("web_url", url);
            intent.putExtra("title", "\u8d44\u8baf");
            ActivityUtils.startActivity((Intent)intent);
        }
        catch (Exception e) {
            ToastUtils.showShort((CharSequence)("\u65e0\u6cd5\u6253\u5f00\u76f8\u5173\u65b0\u95fb\u9875\u9762\uff1a" + e.getMessage()));
        }
    }

    public static void openLesson(String url) {
        try {
            String regex = "^/course/(\\d+)/task/(\\d+)$";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(url);
            if (matcher.matches()) {
                String courseId = matcher.group(1);
                String taskId = matcher.group(2);
                System.out.println("courseId: " + courseId);
                System.out.println("taskId: " + taskId);
                Intent intent = new Intent();
                intent.setClassName(AISDKParams.PACKAGE_NAME, AISDKParams.LEARN_LESSON_ACTIVITY_NAME);
                intent.putExtra("sdk", AIAssistantSDK.getPackageName());
                if (!StringUtils.isEmpty((CharSequence)courseId)) {
                    intent.putExtra("courseId", Integer.parseInt(courseId));
                }
                if (!StringUtils.isEmpty((CharSequence)taskId)) {
                    intent.putExtra("taskId", Integer.parseInt(taskId));
                }
                ActivityUtils.startActivity((Intent)intent);
            } else {
                ToastUtils.showShort((CharSequence)"\u65e0\u6cd5\u83b7\u53d6\u8bfe\u65f6\u4fe1\u606f");
            }
        }
        catch (Exception e) {
            ToastUtils.showShort((CharSequence)("\u65e0\u6cd5\u6253\u5f00\u76f8\u5173\u5b66\u4e60\u9875\u9762\uff1a" + e.getMessage()));
        }
    }

    public static AISendMessage createTextMessage(String content, String domainId, MetaData metaData) {
        return new AISendMessage("user", content, domainId, metaData);
    }

    public static AISendMessage createAudioTextMessage(String content, String domainId, boolean audio, long audioDuration, MetaData metaData) {
        return new AISendMessage("user", content, domainId, audio, audioDuration, metaData);
    }

    public static AISendMessage createGeneratedPlanMessage(String startDate, String endDate, String dailyLearnDuration, List<Integer> list, String content, String domainId, MetaData metaData) {
        WorkflowRequest workflowRequest = new WorkflowRequest();
        workflowRequest.setGeneratedPlanConfig("plan.generate", metaData.getCourseId(), startDate, endDate, dailyLearnDuration, list);
        return new AISendMessage("user", content, domainId, metaData, workflowRequest);
    }

    public static AISendMessage createQuestionAnalysisMessage(String content, String question, String domainId, MetaData metaData) {
        WorkflowRequest workflowRequest = new WorkflowRequest();
        workflowRequest.setQuestionAnalysis("teacher.question.analysis", domainId, question);
        return new AISendMessage("user", content, domainId, metaData, workflowRequest);
    }

    public static String convertMessagesToString(List<String> unreadMessages) {
        if (unreadMessages == null || unreadMessages.isEmpty()) {
            return "";
        }
        if (unreadMessages.size() == 1) {
            return unreadMessages.get(0) != null ? unreadMessages.get(0) : "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < unreadMessages.size(); ++i) {
            String message = unreadMessages.get(i);
            sb.append(message != null ? message : "");
            if (i >= unreadMessages.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

