/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.aiassistant.widget;

import android.content.Context;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatTextView;

public class GradientTextView
extends AppCompatTextView {
    private int[] colors;
    private Shader.TileMode tileMode = Shader.TileMode.CLAMP;

    public GradientTextView(Context context) {
        super(context);
        this.init();
    }

    public GradientTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GradientTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.colors = new int[]{-6802689, -13484801, -13455873};
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            double radians = Math.toRadians(315.0);
            float width = this.getWidth();
            float height = this.getHeight();
            float length = (float)Math.sqrt(width * width + height * height);
            float startX = (float)((double)(-length) * Math.cos(radians) / 2.0 + (double)(width / 2.0f));
            float startY = (float)((double)length * Math.sin(radians) / 2.0 + (double)(height / 2.0f));
            float endX = (float)((double)length * Math.cos(radians) / 2.0 + (double)(width / 2.0f));
            float endY = (float)((double)(-length) * Math.sin(radians) / 2.0 + (double)(height / 2.0f));
            LinearGradient gradient = new LinearGradient(startX, startY, endX, endY, this.colors, null, this.tileMode);
            this.getPaint().setShader((Shader)gradient);
        }
    }
}

