/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.cloud.player.utils;

import android.content.Context;
import com.blankj.utilcode.util.LogUtils;
import com.google.android.exoplayer2.database.DatabaseProvider;
import com.google.android.exoplayer2.database.ExoDatabaseProvider;
import com.google.android.exoplayer2.upstream.cache.CacheEvictor;
import com.google.android.exoplayer2.upstream.cache.LeastRecentlyUsedCacheEvictor;
import com.google.android.exoplayer2.upstream.cache.SimpleCache;
import java.io.File;

public class VideoCache {
    public static final long M_1000 = 1048576000L;
    public static final long B_1000 = 1000L;
    public static SimpleCache sDownloadCache;
    public static ExoDatabaseProvider sExoDatabaseProvider;
    public static File downloadDirectory;
    public static long mCacheSize = 1000L;

    public static synchronized SimpleCache getInstance(Context object) {
        String string = VideoCache.getDownloadDirectory(object).getAbsolutePath();
        if (sDownloadCache == null) {
            string = string + File.separator + "resource-player-cache";
            boolean bl = SimpleCache.isCacheFolderLocked((File)new File(string));
            LogUtils.d((Object[])new Object[]{"VideoCache", "isLocked: " + bl});
            if (!bl) {
                LeastRecentlyUsedCacheEvictor leastRecentlyUsedCacheEvictor;
                File file;
                LogUtils.d((Object[])new Object[]{"VideoCache", "path: " + string});
                Context context = object;
                object = file;
                file = new File(string);
                string = leastRecentlyUsedCacheEvictor;
                leastRecentlyUsedCacheEvictor = new LeastRecentlyUsedCacheEvictor(mCacheSize);
                DatabaseProvider databaseProvider = VideoCache.getDatabaseProvider(context);
                sDownloadCache = new SimpleCache((File)object, (CacheEvictor)string, databaseProvider);
                LogUtils.d((Object[])new Object[]{"VideoCache", "mCacheSize: " + mCacheSize});
            }
        }
        return sDownloadCache;
    }

    public static void setCached(boolean bl) {
        mCacheSize = bl ? 1048576000L : 1000L;
    }

    public static synchronized void clear(Context context) {
        String string = VideoCache.getDownloadDirectory(context).getAbsolutePath();
        string = string + File.separator + "resource-player-cache";
        if (sDownloadCache != null) {
            SimpleCache.delete((File)new File(string), (DatabaseProvider)VideoCache.getDatabaseProvider(context));
        }
    }

    public static synchronized DatabaseProvider getDatabaseProvider(Context context) {
        if (sExoDatabaseProvider == null) {
            sExoDatabaseProvider = new ExoDatabaseProvider(context);
        }
        return sExoDatabaseProvider;
    }

    public static synchronized File getDownloadDirectory(Context context) {
        if (downloadDirectory == null) {
            downloadDirectory = context.getCacheDir();
        }
        LogUtils.d((Object[])new Object[]{"VideoCache", "getDownloadDirectory: " + downloadDirectory.getAbsolutePath()});
        return downloadDirectory;
    }
}

